﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

/**
 * @file
 * @brief       デバイスアセットに関する API の宣言
 */

#pragma once

#include <nn/nn_Macro.h>
#include <nns/hid/hid_DeviceAssetId.h>

namespace nns { namespace hid {

// 依存クラスの前方宣言です。
class ControllerManager;

/**
 * @brief   デバイスアセットの基底クラスです。
 */
class DeviceAsset
{
    NN_DISALLOW_COPY(DeviceAsset);
    NN_DISALLOW_MOVE(DeviceAsset);

public:
    /**
     * @brief       DeviceAsset のコンストラクタです。
     *
     * @param[in]   pManager                    デバイスアセットの管理者です。
     */
    explicit DeviceAsset(ControllerManager* pManager) NN_NOEXCEPT;

    /**
     * @brief       DeviceAsset のデストラクタです。
     */
    virtual ~DeviceAsset() NN_NOEXCEPT;

    /**
     * @brief       デバイスアセット識別子を返します。
     *
     * @return      デバイスアセット識別子です。
     */
    virtual DeviceAssetId GetDeviceAssetId() NN_NOEXCEPT = 0;

    /**
     * @brief       デバイスアセットの状態を更新します。
     *
     * @details     更新はコントローラの状態の更新よりも先にフレーム毎に行う必要があります。
     */
    virtual void Update() NN_NOEXCEPT = 0;

    /**
     * @brief       デバイスアセットの管理者を返します。
     *
     * @return      デバイスアセットの管理者です。
     */
    ControllerManager* GetControllerManager() const NN_NOEXCEPT
    {
        return m_pManager;
    }

private:
    ControllerManager* m_pManager;  //!< デバイスアセットの管理者です。
};

}} // namespace nns::hid
