﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

/**
 * @file
 * @brief   ディスプレイドライバに関する API の宣言
 */

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include <nn/os/os_SystemEvent.h>


namespace nns { namespace display0 {

//-----------------------------------------------------------------------------
//! @name ディスプレイドライバ関連の API
//! @{

//-----------------------------------------------------------------------------
/**
 * @brief   ディスプレイドライバの処理を開始します。
 *
 * @param[in] systemEvent   システムイベントオブジェクトへのポインタ
 *
 * @details
 *  ディスプレイドライバの処理を開始します。@n
 *  具体的には、指定されたシステムイベントのシグナル化に同期して
 *  ログ出力を行ないます。
 *
 */
void StartDisplay0(nn::os::SystemEventType* systemEvent) NN_NOEXCEPT;

//-----------------------------------------------------------------------------
/**
 * @brief   ディスプレイドライバの処理を停止します。
 *
 * @details
 *  ディスプレイドライバの処理を停止します。
 *
 */
void StopDisplay0() NN_NOEXCEPT;

//! @}
//-----------------------------------------------------------------------------

}} // namespace nns::display0

