﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Macro.h>
#include <nn/bluetooth.h>

namespace nns { namespace ble {
/**
 * @brief       接続できるクライアントの最大数です
 */
const int ClientCountMax = nn::bluetooth::GATT_CLIENT_MAX_NUM;

/*
 * @brief       GATT Client のステートを表す構造体です。
 */
struct GattClientStatus
{
    nn::bluetooth::BleClientConnState   connState;                                          //!< 接続状態
    nn::bluetooth::GattService          services[nn::bluetooth::GATT_ATTR_NUM_MAX];         //!< 接続しているGATT Server のService
    nn::bluetooth::GattCharacteristic   characteristics[nn::bluetooth::GATT_ATTR_NUM_MAX];  //!< 接続しているGATT Server のCharacteristic
    nn::bluetooth::GattDescriptor       descriptors[nn::bluetooth::GATT_ATTR_NUM_MAX];      //!< 接続しているGATT Server のDescriptor
    uint16_t                            serviceNum;                                         //!< 接続しているGATT Server のService 数
    uint16_t                            characteristicNum;                                  //!< 接続しているGATT Server のCharacteristic 数
    uint16_t                            descriptorNum;                                      //!< 接続しているGATT Server のDescriptor 数
    uint16_t                            mtu;                                                //!< MTU
};

}}  // nns::ble
