﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nns/afx/afx_SimpleDelayApi.h>
#include <nns/afx/afx_SimpleDelayTypes.h>

namespace nns { namespace afx {

/**
 * @brief       SimpleDelay クラスです。CTR-SDK における nn::snd::FxDelay と同等の処理を行います。
 */
class SimpleDelay
{
public:
    /**
     * @brief       初期化パラメータです。
     * @details
     * 詳細は SimpleDelayConstant を参照してください。
     */
    using Constant = SimpleDelayConstant;

    /**
     * @brief       可変パラメータです。
     * @details
     * 詳細は SimpleDelayParameter を参照してください。
     */
    using Parameter = SimpleDelayParameter;

    /**
     * @brief       必要なメモリサイズを返します。
     * @param[in]   c 初期化パラメータ
     * @return      メモリサイズを返します。
     * @details
     * 詳細は GetRequiredMemorySizeForSimpleDelay() を参照してください。
     */
    static size_t GetRequiredMemorySize(const Constant* c)
    {
        return GetRequiredMemorySizeForSimpleDelay(c);
    }

    /**
     * @brief       初期化します。
     * @param[in]   buffer 作業用メモリ
     * @param[in]   size 作業用メモリのサイズ
     * @param[in]   c 初期化パラメータ
     * @details
     * 詳細は InitializeSimpleDelay() を参照してください。
     */
    void Initialize(void* buffer, size_t size, const Constant* c)
    {
        return InitializeSimpleDelay(&m_Effect, buffer, size, c);
    }

    /**
     * @brief       終了処理を行います。
     * @return      使用していた作業用メモリを返します。
     * @details
     * 詳細は FinalizeSimpleDelay() を参照してください。
     */
    void* Finalize()
    {
        return FinalizeSimpleDelay(&m_Effect);
    }

    /**
     * @brief       初期化パラメータを取得します。
     * @return      初期化パラメータを返します。
     * @details
     * 詳細は GetSimpleDelayConstant() を参照してください。
     */
    Constant GetConstant() const
    {
        return GetSimpleDelayConstant(&m_Effect);
    }

    /**
     * @brief       可変パラメータを取得します。
     * @return      可変パラメータを返します。
     * @details
     * 詳細は GetSimpleDelayParameter() を参照してください。
     */
    Parameter GetParameter() const
    {
        return GetSimpleDelayParameter(&m_Effect);
    }

    /**
     * @brief       可変パラメータを設定します。
     * @param[in]   p 可変パラメータ
     * @details
     * 詳細は SetSimpleDelayParameter() を参照してください。
     */
    void SetParameter(const Parameter* p)
    {
        return SetSimpleDelayParameter(&m_Effect, p);
    }

    /**
     * @brief       エフェクトを適用します。
     * @param[out]  outputs 出力バッファ
     * @param[in]   inputs 入力バッファ
     * @param[in]   channelCount outputs/inputs のチャンネル数
     * @param[in]   sampleCount outputs/inputs のサンプル数
     * @details
     * 詳細は ApplySimpleDelay() を参照してください。
     */
    void Apply(int32_t* outputs[], const int32_t* const inputs[], int channelCount, int sampleCount)
    {
        return ApplySimpleDelay(&m_Effect, outputs, inputs, channelCount, sampleCount);
    }

private:
    SimpleDelayType m_Effect;
};

}}  // namespace nns::afx
