﻿/*---------------------------------------------------------------------------*
  Project:  NintendoWare

  Copyright (C)Nintendo/HAL Laboratory, Inc.  All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *---------------------------------------------------------------------------*/

// バージョン宣言は先頭に行う必要があるため、このファイルは最初にインクルードしなければなりません。

#if NW_GX2
#version 330
#elif NW_GL
#version 330
#endif

#ifdef ENABLE_CUBE_ARRAY
#extension GL_ARB_texture_cube_map_array : enable
#endif

//--------------------------------------------------------------------------------------------------
// varying 構造体を1か所で定義するためのマクロ

#if NW_VERTEX_SHADER

#define NW_PRIMITIVE out NWPrimitive
#define nw_primitive OUT

#define NW_RASTER out NWRaster
#define nw_raster OUT

#elif NW_GEOMETRY_SHADER

#define NW_PRIMITIVE in NWPrimitive
#define nw_primitive IN[]

#define NW_RASTER out NWRaster
#define nw_raster OUT

#elif NW_FRAGMENT_SHADER

#define NW_RASTER in NWRaster
#define nw_raster IN

#endif

//--------------------------------------------------------------------------------------------------
// 関数型マクロ

// vec4[3] * vec4(vec3, 1)
#define NW_G3D_TRANSFORM_POS(mtx, pos) vec3( \
    dot(mtx[0].xyzw, pos.xyzw), \
    dot(mtx[1].xyzw, pos.xyzw), \
    dot(mtx[2].xyzw, pos.xyzw))

// vec3[3] * vec3
#define NW_G3D_TRANSFORM_VEC(mtx, vec) vec3( \
    dot(mtx[0].xyz, vec.xyz), \
    dot(mtx[1].xyz, vec.xyz), \
    dot(mtx[2].xyz, vec.xyz))

// vec4[3] * vec4(vec3, 1)
#define NW_G3D_TRANSFORM_POS_OFFSET(mtx, offset, pos) vec3( \
    dot(mtx[(offset)    ].xyzw, pos.xyzw), \
    dot(mtx[(offset) + 1].xyzw, pos.xyzw), \
    dot(mtx[(offset) + 2].xyzw, pos.xyzw))

// vec3[3] * vec[3]
#define NW_G3D_TRANSFORM_VEC_OFFSET(mtx, offset, vec) vec3( \
    dot(mtx[(offset)    ].xyz, vec.xyz), \
    dot(mtx[(offset) + 1].xyz, vec.xyz), \
    dot(mtx[(offset) + 2].xyz, vec.xyz))

// vec4[4] * vec4
#define NW_G3D_PROJECT(mtx, pos) vec4( \
    dot(mtx[0].xyzw, pos.xyzw), \
    dot(mtx[1].xyzw, pos.xyzw), \
    dot(mtx[2].xyzw, pos.xyzw), \
    dot(mtx[3].xyzw, pos.xyzw))

// vec4[4] * vec4
#define NW_G3D_PROJECT_OFFSET(mtx, offset, pos) vec4( \
    dot(mtx[(offset) + 0], pos), \
    dot(mtx[(offset) + 1], pos), \
    dot(mtx[(offset) + 2], pos), \
    dot(mtx[(offset) + 3], pos))

// vec4[2] * vec2
#define NW_G3D_TRANSFORM_UV(mtx, uv) vec2( \
    mtx[0].xy * uv.x + mtx[0].zw * uv.y + mtx[1].xy);

#define NW_G3D_TO_BOOL(value) ((value) != 0)

/// 投影用の符号
#if defined( NW_GX2 )
#   define  NW_G3D_PROJECTION_DIR(x) (x)
#else
#   define  NW_G3D_PROJECTION_DIR(x) (-1.0 * (x))
#endif
