﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#ifndef NW_G3D_DEMO_GPUMETRIC_H_
#define NW_G3D_DEMO_GPUMETRIC_H_

#include <nw/g3d/g3d_config.h>

namespace nw { namespace g3d { namespace demo {

struct GPUMetricData
{
    u64     m_Time;                 //!< 計測区間の合計(ms)
    u64     m_GPUTime;              //!< 計測区間のGPUだけの時間(ms)
    f32     m_GPUBusy;              //!< 計測区間でのGPUのBusy割合(%)
    f32     m_ShaderBusy;           //!< GPUのBusy割合に対するShaderのBusy割合(%)
    u64     m_ReusedIndices;        //!< PostTransformCacheにヒットしたインデックス数

    f32     m_ALUBusy;              //!< ShaderBusyに対するALUのInstructionのBusy割合(%)
    f32     m_TexBusy;              //!< ShaderBusyに対するTextureのInstructionのBusy割合(%)
    u64     m_VSVerticesIn;         //!< 頂点シェーダに入ってきた頂点数(個)
    u64     m_FSPixelsIn;           //!< FragmentShaderに入ってきたピクセル数(個)
    u64     m_FSPixelsOut;          //!< フラグメントシェーダからの送出ピクセル数(個)
    f32     m_FSExportStall;        //!< FragmentShaderからの送出時のストール(%)

    struct Shader
    {
        f32 m_Busy;                 //!< GPUBusyに対するShaderのBusy割合(%)
        f32 m_TexInstCount;         //!< TEXのインストラクション数(個)
        f32 m_TexBusy;              //!< TEXのBusy割合(%)
        f32 m_ALUInstCount;         //!< ALUのインストラクション数(個)
        f32 m_ALUBusy;              //!< ALUのBusy割合(%)
        f32 m_ALUEfficiency;        //!< ALUのベクター演算器にインストラクションをパッキングする際の効率(%)
        f32 m_ALUTexRatio;          //!< TEXからはみ出たALUのインストラクション割合(%) ?
    };

    Shader  m_VS;                   //!< 頂点シェーダ
    Shader  m_GS;                   //!< ジオメトリシェーダ
    Shader  m_FS;                   //!< フラグメントシェーダ

    f32     m_PABusy;               //!< PrimitiveAssembly(PA)のBusy割合(%)
    u64     m_PAIn;                 //!< 入力Primitive数(個)
    f32     m_PAStalledOnRas;       //!< PAのRasterizerでのストール割合(%)
    f32     m_InterpolatorBusy;     //!< InterpolatorBusy割合(%)

    f32     m_TexUnitBusy;          //!< TextureUnitのBusy割合(%)
    u64     m_TexelFetch;           //!< TextureFetchの回数(回)
    f32     m_TexCacheStall;        //!< GPUBusyに対するTextureCacheのストール割合(%)
    f32     m_TexMissRate;          //!< Textureのミスレート(bytes/texel)
    u64     m_TexReadMemByte;       //!< Textureの読み込みメモリ(バイト)

    f32     m_DepthStencilTestBusy; //!< DepthとStencilテストのBusy割合(%)
    f32     m_HiZTrivialAccept;     //!< HiZのトリビアルなアクセプト割合(%)
    f32     m_HiZReject;            //!< HiZのリジェクト割合(%)

    u64     m_PreZSamplePassing;    //!< アーリーデプスでの通過サンプル数(個)
    u64     m_PreZSampleFailingS;   //!< アーリーデプスでのステンシルの失敗サンプル数(個)
    u64     m_PreZSampleFailingZ;   //!< アーリーデプスでのデプスの失敗サンプル数(個)
    u64     m_PostZSamplePassing;   //!< レイトデプスでの通過サンプル数(個)
    u64     m_PostZSampleFailingS;  //!< レイトデプスでのステンシルの失敗サンプル数(個)
    u64     m_PostZSampleFailingZ;  //!< レイトデプスでのデプスの失敗サンプル数(個)

    f32     m_ZUnitStalled;         //!< デプスユニットのストール(%)
    u64     m_ColorPixelsWritten;   //!< ColorBufferに描きこまれたピクセル数(個)
    u64     m_ColorWriteByte;       //!< ColorBufferに描きこまれたメモリ(バイト)

    u64     m_IAVertices;           //!< FetchShader
    u64     m_IAPrimitive;          //!<
    u64     m_VSInvocations;        //!<
    u64     m_GSInvocations;        //!<
    u64     m_GSPrimitives;         //!<
    u64     m_CInvocations;         //!<
    u64     m_CPrimitives;          //!<
    u64     m_FSInvocations;        //!<
    u64     m_FSInputPrimitive;
};

// メトリックの計測
class GPUMetric
{
public:
    GPUMetric()
    {
        m_pData[0] = m_pData[1] = NULL;
        m_FrameCount[0] = m_FrameCount[1] = -1;
        m_CurrentPerf = 0;
        m_IsCalcComplete = false;
    }
    ~GPUMetric() {}

    void Setup();
    void Cleanup();

    void Begin();
    void End();
    void Calc(bool useDisplayList);
    bool IsCalcComplete();

    void Print();

private:
    void Clear(int index);

#ifndef _WIN32
    MEMAllocator m_Allocator;
#endif
    GPUMetricData m_Result;
    void* m_pData[2];
    int m_FrameCount[2];
    int m_CurrentPerf;
    bool m_IsCalcComplete;

};

}}} // namespace nw::g3d::demo

#endif // NW_G3D_DEMO_GPUMETRIC_H_
