﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using NAudio.Wave;
using Nintendo.ToolFoundation.Contracts;

namespace NintendoWare.Spy
{
    internal class WasapiWaveProvider : IWaveProvider
    {
        private const int PlaybackChannels = 2; // HACK : とりあえず 2ch

        //-----------------------------------------------------------------

        private readonly IWaveSource _waveSource;
        private readonly WaveFormat _waveFormat;

        //-----------------------------------------------------------------

        public WasapiWaveProvider(IWaveSource waveSource)
        {
            Ensure.Argument.NotNull(waveSource);

            _waveSource = waveSource;
            _waveFormat = new WaveFormat(waveSource.SamplingRate, waveSource.BitsPerSample, PlaybackChannels);
        }

        //-----------------------------------------------------------------

        public string TargetName { get; set; }

        WaveFormat IWaveProvider.WaveFormat
        {
            get { return _waveFormat; }
        }

        //-----------------------------------------------------------------

        int IWaveProvider.Read(byte[] buffer, int offset, int count)
        {
            if (_waveSource == null)
            {
                return 0;
            }

            return _waveSource.Mix(buffer, offset, count, this.TargetName, PlaybackChannels);
        }
    }
}
