﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System.Threading;
using System.Windows;

namespace NintendoWare.Spy
{
    public static class ClipboardUtility
    {
        private const int RetryCount = 4;
        private const int WaitMilliSeconds = 500;

        public static void SetText(string text)
        {
            bool success = false;
            for (int i = 0; !success && i < RetryCount; ++i)
            {
                try
                {
                    Clipboard.SetText(text);
                    success = true;
                }
                catch (System.Runtime.InteropServices.COMException e)
                {
                    // クリップボードを他のプロセスが開いていると例外が発生する。
                    // CLIPBRD_E_CANT_OPEN
                    if (e.ErrorCode == unchecked((int)0x800401D0))
                    {
                        Thread.Sleep(WaitMilliSeconds);
                    }
                    else
                    {
                        throw;
                    }
                }
            }

            if (!success)
            {
                MessageBox.Show(
                    "Failed to copy to the clipboard. Other application might be open the clipboard.",
                    "Spy",
                    MessageBoxButton.OK,
                    MessageBoxImage.Error);
            }
        }
    }
}
