﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.ComponentModel;

namespace NintendoWare.Spy
{
    /// <summary>
    /// モックアップを実装できるように
    /// WaveformSpyModel のラウドネスに関するインターフェースを抽出したものです。
    /// </summary>
    public interface ILoudnessProvider : INotifyPropertyChanged
    {
        event EventHandler LoudnessUpdateEvent;

        bool IsWaveformMetadataReady { get; }

        SpyTime BeginTime { get; }

        int SampleRate { get; }

        bool IsLoudnessAvailable { get; }

        int LoudnessStepSampleCount { get; }

        int LoudnessCount { get; }

        WaveformSpyModel.LoudnessInfo GetLoudness(int loudnessIndex);

        void UpdateLoudness();
    }
}
