﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using Nintendo.ToolFoundation.Contracts;
using System;

namespace NintendoWare.Spy
{
    /// <summary>
    /// Spy Raw データイベントに関する情報を格納します。
    /// </summary>
    public sealed class SpyRawDataEventArgs : EventArgs
    {
        private static readonly Version EmptyVersion = new Version();

        private readonly uint _dataID;
        private readonly byte[] _rawData;
        private readonly long _timestamp;
        private string _dataName = string.Empty;
        private Version _dataVersion = EmptyVersion;

        //-----------------------------------------------------------------

        /// <summary>
        /// コンストラクタです。
        /// </summary>
        /// <param name="dataID">データ ID を指定します。</param>
        /// <param name="rawData">Raw データを指定します。</param>
        /// <param name="timestamp">パケットの送信時間[usec]を指定します。</param>
        public SpyRawDataEventArgs(uint dataID, byte[] rawData, long timestamp)
        {
            Assertion.Argument.NotNull(rawData);

            _dataID = dataID;
            _rawData = rawData;
            _timestamp = timestamp;
        }

        //-----------------------------------------------------------------

        /// <summary>
        /// データ ID を取得します。
        /// </summary>
        public uint DataID
        {
            get { return _dataID; }
        }

        /// <summary>
        /// Rawデータを取得します。
        /// </summary>
        public byte[] RawData
        {
            get { return _rawData; }
        }

        /// <summary>
        /// パケット送信時間[usec]を取得します。
        /// </summary>
        public long Timestamp
        {
            get { return _timestamp; }
        }

        /// <summary>
        /// データのタイプ名を取得します。
        /// </summary>
        public string DataName
        {
            get { return _dataName; }
        }

        public Version DataVersion
        {
            get { return _dataVersion; }
        }

        /// <summary>
        /// データの型情報を設定します。
        /// </summary>
        /// <param name="dataName"></param>
        /// <param name="dataVersion"></param>
        public void SetDataInfo(string dataName, Version dataVersion)
        {
            _dataName = dataName;
            _dataVersion = dataVersion;
        }
    }
}
