﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using NintendoWare.Spy.Windows;
using System;
using System.Collections.Generic;

namespace NintendoWare.Spy
{
    /// <summary>
    /// Spy の一時的なデータを管理する機能を提供します。
    /// ここに設定されたデータは永続化されません。
    /// </summary>
    public class SpyTemporaryDataService
    {
        private readonly Dictionary<Type, object> _items = new Dictionary<Type, object>();

        /// <summary>
        /// Spy で選択中の接続先情報を取得します。
        /// </summary>
        public SpyConnectionInfo GetSpyConnectionInfo()
        {
            return this.GetOrAddValue<SpyConnectionInfo>(() => new SpyConnectionInfo());
        }

        /// <summary>
        /// 指定した型のインスタンスを取得または生成します。
        /// 型が見つからない場合は、指定関数を使ってインスタンスを生成します。
        /// </summary>
        /// <typeparam name="TValue">値の型を指定します。</typeparam>
        /// <returns>インスタンスを返します。</returns>
        private TValue GetOrAddValue<TValue>(Func<TValue> createValue)
        {
            TValue result;
            if (_items.ContainsKey(typeof(TValue)))
            {
                result = (TValue)_items[typeof(TValue)];
            }
            else
            {
                result = createValue();
                _items.Add(typeof(TValue), result);
            }

            return result;
        }
    }
}
