﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using Nintendo.ToolFoundation.Contracts;
using NintendoWare.Spy.Commands;
using NintendoWare.Spy.Foundation.Commands;
using System;
using System.Windows.Input;

namespace NintendoWare.Spy.Windows
{
    public sealed class CommandServiceCommand : ICommand
    {
        private readonly CommandService _commandService;
        private readonly Command _command;
        private readonly Func<object, CommandArgs> _createCommandArgs;

        //-----------------------------------------------------------------

        public CommandServiceCommand(
            CommandService commandService,
            Command command,
            Func<object, CommandArgs> createCommandArgs = null)
        {
            Ensure.Argument.NotNull(commandService);
            Ensure.Argument.NotNull(command);

            _commandService = commandService;
            _command = command;
            _createCommandArgs = createCommandArgs;
        }

        /// <summary>
        /// 実行可能変更イベントです。
        /// </summary>
        public event EventHandler CanExecuteChanged
        {
            add { CommandManager.RequerySuggested += value; }
            remove { CommandManager.RequerySuggested -= value; }
        }

        /// <summary>
        /// 実行可能か判定します。
        /// </summary>
        /// <param name="parameter">コマンド対象です。</param>
        /// <returns>実行可能なら true を返します。</returns>
        public bool CanExecute(object parameter)
        {
            return _commandService.QueryStatus(
                _command,
                _createCommandArgs == null ? null : _createCommandArgs(parameter))
                .IsEnabled();
        }

        /// <summary>
        /// 実行します。
        /// </summary>
        /// <param name="parameter">コマンドパラメータです。</param>
        public void Execute(object parameter)
        {
            _commandService.Execute(
                _command,
                _createCommandArgs == null ? null : _createCommandArgs(parameter));
        }
    }
}
