﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using Nintendo.ToolFoundation.Contracts;
using System;
using System.Globalization;
using System.Windows.Data;

namespace NintendoWare.Spy.Windows
{
    /// <summary>
    /// 時間の単位に応じて SpyTime を文字列に変換します。
    /// </summary>
    public sealed class SpyTimeMultiValueConverter : IMultiValueConverter
    {
        public object Convert(object[] values, Type targetType, object parameter, CultureInfo culture)
        {
            if (targetType == typeof(string))
            {
                SpyTime time = null;
                SpyTimeUnit timeUnit = SpyTimeUnit.Timestamp;

                foreach (var value in values)
                {
                    if (value is SpyTime)
                    {
                        time = (SpyTime)value;
                    }
                    else if (value is SpyTimeUnit)
                    {
                        timeUnit = (SpyTimeUnit)value;
                    }
                }

                Ensure.Argument.NotNull(time, "SpyTime is not specified.");

                return time.ToLabelString(timeUnit);
            }

            throw new ArgumentException("unexpected values.");
        }

        public object[] ConvertBack(object value, Type[] targetTypes, object parameter, CultureInfo culture)
        {
            throw new NotImplementedException();
        }
    }
}
