﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using Nintendo.ToolFoundation.Contracts;
using System.Windows.Controls;
using System.Windows.Forms.Integration;
using System.Windows.Media;

namespace NintendoWare.Spy.Windows
{
    /// <summary>
    /// Windows Forms ベースの Spy パネルのプレゼンターです。
    /// </summary>
    public abstract class FormsSpyPanelPresenter : SpyPanelPresenter
    {
        private WindowsFormsHost FormsHost => (this.Content as ContentControl)?.Content as WindowsFormsHost;

        /// <summary>
        /// コンテントを生成します。
        /// </summary>
        /// <returns>生成したコンテントを返します。</returns>
        protected sealed override Control CreateContent()
        {
            var formsContent = this.CreateControl();
            Ensure.Operation.NotNull(formsContent);

            formsContent.Dock = System.Windows.Forms.DockStyle.Fill;

            var formsHost = new WindowsFormsHost();
            formsHost.Child = formsContent;

            // Tab や カーソルキーによるフォーカス移動の境界となるよう ContentControl を挟みます。
            // Background が null や Transparent だと WinForms コントロールの背景が透けてしまうので、
            // それ以外のデフォルトブラシを指定します。
            var container = new ContentControl()
            {
                Content = formsHost,
                Background = Brushes.DimGray,
            };

            return container;
        }

        protected sealed override void SetAvailability(bool isAvailable)
        {
            if (!isAvailable)
            {
                // FormsHost の上には Adorner を表示できないので、無効時は FormsHost を非表示にする
                FormsHost.Visibility = System.Windows.Visibility.Collapsed;
            }
            else
            {
                FormsHost.Visibility = System.Windows.Visibility.Visible;
            }

            base.SetAvailability(isAvailable);
        }

        /// <summary>
        /// System.Windows.Forms.Control を生成します。
        /// </summary>
        /// <returns>生成した System.Windows.Forms.Control を返します。</returns>
        protected abstract System.Windows.Forms.Control CreateControl();
    }
}
