﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using NintendoWare.Spy.Framework.Settings;

namespace NintendoWare.Spy.Settings
{
    /// <summary>
    /// 設定へのアクセスを簡略化するヘルパークラスです。
    /// </summary>
    public static class SettingsAccessor
    {
        /// <summary>
        /// アプリケーション設定を取得します。
        /// </summary>
        /// <param name="service">SettingsService を指定します。</param>
        /// <returns>ApplicationSettings を返します。</returns>
        public static ApplicationSettings GetApplicationSettings(this SettingsService service)
        {
            return service.GetSettingItemValue<ApplicationSettings>(ConstConfig.SettingItemKeys.ApplicationSettingsKey);
        }

        /// <summary>
        /// 接続設定を取得します。
        /// </summary>
        /// <param name="service">SettingsService を指定します。</param>
        /// <returns>ConnectionSettings を返します。</returns>
        public static ConnectionSettings GetConnectionSettings(this SettingsService service)
        {
            return service.GetSettingItemValue<ConnectionSettings>(ConstConfig.SettingItemKeys.ConnectionSettingsKey);
        }

        /// <summary>
        /// CafeAudio 設定を取得します。
        /// </summary>
        /// <param name="service">SettingsService を指定します。</param>
        /// <returns>CafeAudioSettings を返します。</returns>
        public static CafeAudioSettings GetCafeAudioSettings(this SettingsService service)
        {
            return service.GetSettingItemValue<CafeAudioSettings>(ConstConfig.SettingItemKeys.CafeAudioSettingsKey);
        }
    }
}
