﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using Nintendo.ToolFoundation.Collections;

namespace NintendoWare.Spy.Foundation.Commands
{
    /// <summary>
    /// コマンドの実行対象であることを示します。
    /// </summary>
    public interface ICommandTarget
    {
        /// <summary>
        /// コマンドバインディングの一覧を取得します。
        /// </summary>
        IKeyedList<Command, CommandBinding> CommandBindings { get; }

        /// <summary>
        /// 継承可能なコマンドバインディングの一覧を取得します。
        /// </summary>
        IKeyedList<Command, CommandBinding> InheritableCommandBindings { get; }

        //-----------------------------------------------------------------

        /// <summary>
        /// コマンドターゲットを継承し、親のコマンドバインディングを取り扱えるようにします。
        /// </summary>
        /// <param name="parentCommandTarget">親コマンドターゲットを指定します。</param>
        void Inherit(ICommandTarget parentCommandTarget);

        /// <summary>
        /// コマンドターゲットの継承を解除します。
        /// </summary>
        void Uninherit();
    }
}
