﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using Nintendo.ToolFoundation.Contracts;

namespace NintendoWare.Spy.Foundation.Commands
{
    public class CommandID
    {
        private string _id = string.Empty;

        //-----------------------------------------------------------------

        /// <summary>
        /// コンストラクタです。
        /// </summary>
        /// <param name="id">コマンドID を指定します。</param>
        public CommandID(string id)
        {
            Ensure.Argument.NotNull(id);
            _id = id;
        }

        //-----------------------------------------------------------------

        /// <summary>
        /// 空のコマンドID を取得します。
        /// </summary>
        public static CommandID Empty { get; } = new CommandID(string.Empty);

        /// <summary>
        /// コマンドID を文字列に変換します。
        /// </summary>
        /// <returns>変換した文字列を返します。</returns>
        public override string ToString()
        {
            return _id;
        }

        /// <summary>
        /// 等値比較を行います。
        /// </summary>
        /// <param name="obj">比較するオブジェクトを指定します。</param>
        /// <returns>等しい場合は true、等しくない場合は false を返します。</returns>
        public override bool Equals(object obj)
        {
            var other = obj as CommandID;

            if (other == null)
            {
                return false;
            }

            return _id == other._id;
        }

        /// <summary>
        /// ハッシュコードを取得します。
        /// </summary>
        public override int GetHashCode()
        {
            return _id.GetHashCode();
        }
    }
}
