﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using Nintendo.ToolFoundation.Contracts;

namespace NintendoWare.Spy.Foundation.Commands
{
    /// <summary>
    /// コマンドとハンドラを関連付けるクラスです。
    /// </summary>
    public sealed class CommandBinding
    {
        private readonly Command _command;
        private readonly ICommandHandler _commandHandler;

        //-----------------------------------------------------------------

        public CommandBinding(Command command, ICommandHandler commandHandler)
        {
            Ensure.Argument.NotNull(command);
            Ensure.Argument.NotNull(commandHandler);
            _command = command;
            _commandHandler = commandHandler;
        }

        //-----------------------------------------------------------------

        /// <summary>
        /// コマンドを取得します。
        /// </summary>
        public Command Command
        {
            get { return _command; }
        }

        /// <summary>
        /// コマンドハンドラを取得します。
        /// </summary>
        public ICommandHandler CommandHandler
        {
            get { return _commandHandler; }
        }
    }
}
