﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System.Collections.Generic;
using System.Reflection;

namespace NintendoWare.Spy.Foundation.Binary
{
    /// <summary>
    /// プロパティのバイナリ化をサポートします。
    /// </summary>
    /// <remarks>
    /// リフレクションだとプロパティ列挙の順序が保障されないので、
    /// 明示的に列挙するためのインターフェイスします。
    /// </remarks>
    internal interface IBinarizable
    {
        /// <summary>
        /// バイナリ化対象のプロパティを列挙します。
        /// </summary>
        /// <returns>プロパティ情報の列挙子を返します。</returns>
        IEnumerable<PropertyInfo> GetProperties();
    }
}
