﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
namespace NintendoWare.Spy
{
    /// <summary>
    /// CUI から Spy.exe に送られるコマンドのメッセージです。
    /// </summary>
    public static class CommandMessages
    {
        /// <summary>
        /// <see cref="App.SendCommandMessage"/> の戻り値です。
        /// <para>
        /// 受信側 Spy.exe で不明なコマンドだった場合は <see cref="UnexpectedCommand"/> を返します。
        /// コマンドの実行に成功した場合は正の値を返します。
        /// コマンドの実行に失敗した場合は負の値を返します。
        /// </para>
        /// </summary>
        public static class Result
        {
            /// <summary>
            /// 不明なコマンドだった場合の値です。
            /// </summary>
            public const int UnexpectedCommand = 0;

            /// <summary>
            /// コマンドの実行に成功した場合の標準の値です。
            /// </summary>
            public const int Success = 1;
        }

        /// <summary>
        /// 接続します。
        /// </summary>
        public class Connect
        {
            public const string CommandName = "connect";

            /// <summary>
            /// <see cref="App.SendCommandMessage"/> の戻り値です。
            /// </summary>
            public static class Result
            {
                public const int TargetIsNotSelected = -1;
                public const int NotRunningTargetManager = -2;
            }
        }

        /// <summary>
        /// 切断します。
        /// </summary>
        public class Disconnect
        {
            public const string CommandName = "disconnect";
        }
    }
}
