﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Windows;
using System.Windows.Interactivity;

namespace NintendoWare.Spy.Windows
{
    /// <summary>
    /// 指定アクションを実行する TriggerAction です。
    /// </summary>
    public sealed class InvokeAction : TriggerAction<DependencyObject>
    {
        /// <summary>
        /// トリガー発生時に実行するアクションです。
        /// </summary>
        public static readonly DependencyProperty ActionProperty = DependencyProperty.Register(
                nameof(Action),
                typeof(Action<object>),
                typeof(InvokeAction),
                new FrameworkPropertyMetadata(null));

        //-----------------------------------------------------------------

        /// <summary>
        /// トリガー発生時に実行するアクションを取得または設定します。
        /// </summary>
        public Action<object> Action
        {
            get { return (Action<object>)GetValue(ActionProperty); }
            set { SetValue(ActionProperty, value); }
        }

        //-----------------------------------------------------------------

        protected override void Invoke(object parameter)
        {
            if (this.Action != null)
            {
                this.Action(parameter);
            }
        }
    }
}
