﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using Nintendo.ToolFoundation.ComponentModel;
using Nintendo.ToolFoundation.Windows.Controls;
using System.Windows.Media;

namespace NintendoWare.Spy.Windows
{
    internal class TimelineHorizontalMarkerViewModel : ObservableObject, ILineChartHorizontalMarkerData
    {
        private string _name = string.Empty;
        private bool _isVisible = true;
        private Color _strokeColor = Color.FromArgb(0xf0, 0xf0, 0xf0, 0xf0);
        private Color _backgroundColor = Color.FromArgb(0x60, 0x33, 0x33, 0x33);
        private double _value = 0.0;
        private double _minimumY = double.NaN;
        private double _maximumY = double.NaN;
        private double _centerY = double.NaN;

        public string Name
        {
            get { return _name; }
            set { this.SetPropertyValue(ref _name, value); }
        }

        public bool IsVisible
        {
            get { return _isVisible; }
            set { this.SetPropertyValue(ref _isVisible, value); }
        }

        public Color StrokeColor
        {
            get { return _strokeColor; }
            set { this.SetPropertyValue(ref _strokeColor, value); }
        }

        public Color BackgroundColor
        {
            get { return _backgroundColor; }
            set { this.SetPropertyValue(ref _backgroundColor, value); }
        }

        public double Value
        {
            get { return _value; }
            set { this.SetPropertyValue(ref _value, value); }
        }

        public double MinimumY
        {
            get { return _minimumY; }
            set { this.SetPropertyValue(ref _minimumY, value); }
        }

        public double MaximumY
        {
            get { return _maximumY; }
            set { this.SetPropertyValue(ref _maximumY, value); }
        }

        public double CenterY
        {
            get { return _centerY; }
            set { this.SetPropertyValue(ref _centerY, value); }
        }
    }
}
