﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using Nintendo.ToolFoundation.ComponentModel;
using System.Collections.Generic;
using System.ComponentModel;
using System.Windows.Data;
using System.Windows.Input;

namespace NintendoWare.Spy.Windows
{
    public sealed class OptionWindowViewModel : ObservableObject, IDataErrorInfo
    {
        private const string UpdateIntervalName = "UpdateIntervalText";

        private string _playbackDeviceName = string.Empty;
        private IEnumerable<string> _playbackDevices;

        private SpyTimeUnit _timeUnit = SpyTimeUnit.Timestamp;

        private string _workDirectoryPath = string.Empty;
        private ICommand _openWorkDirectoryPathCommand;
        private ICommand _resetPanelLayoutCommand;

        private ICommand _okCommand;
        private ICommand _cancelCommand;

        private string _updateIntervalText = string.Empty;

        //-----------------------------------------------------------------

        public string PlaybackDeviceName
        {
            get { return _playbackDeviceName; }
            set { this.SetPropertyValue(ref _playbackDeviceName, value); }
        }

        public ICollectionView PlaybackDeviceNames
        {
            get
            {
                return _playbackDevices == null ?
                    null : CollectionViewSource.GetDefaultView(_playbackDevices);
            }
        }

        public int UpdateInterval
        {
            get { return int.Parse(this.UpdateIntervalText); }
            set { this.UpdateIntervalText = value.ToString(); }
        }

        public string UpdateIntervalText
        {
            get { return _updateIntervalText; }
            set { this.SetPropertyValue(ref _updateIntervalText, value); }
        }

        public SpyTimeUnit TimeUnit
        {
            get { return _timeUnit; }
            set { this.SetPropertyValue(ref _timeUnit, value); }
        }

        public string WorkDirectoryPath
        {
            get { return _workDirectoryPath; }
            set { this.SetPropertyValue(ref _workDirectoryPath, value); }
        }

        public ICommand OpenWorkDirectoryPathCommand
        {
            get { return _openWorkDirectoryPathCommand; }
            set { this.SetPropertyValue(ref _openWorkDirectoryPathCommand, value); }
        }

        public ICommand ResetPanelLayoutCommand
        {
            get { return _resetPanelLayoutCommand; }
            set { this.SetPropertyValue(ref _resetPanelLayoutCommand, value); }
        }

        public ICommand OKCommand
        {
            get { return _okCommand; }
            set { this.SetPropertyValue(ref _okCommand, value); }
        }

        public ICommand CancelCommand
        {
            get { return _cancelCommand; }
            set { this.SetPropertyValue(ref _cancelCommand, value); }
        }

        string IDataErrorInfo.Error
        {
            get
            {
                return null;
            }
        }

        string IDataErrorInfo.this[string name]
        {
            get
            {
                return this.GetErrorMessage(name);
            }
        }

        //-----------------------------------------------------------------

        public void Setup(IEnumerable<string> playbackDevices)
        {
            if (_playbackDevices == playbackDevices)
            {
                return;
            }

            _playbackDevices = playbackDevices;
            this.NotifyPropertyChanged(() => this.PlaybackDeviceNames);
        }

        public bool HasError
        {
            get
            {
                string[] names = new string[]
                    {
                        UpdateIntervalName,
                    };

                foreach (string name in names)
                {
                    if (this.GetErrorMessage(name) != null)
                    {
                        return true;
                    }
                }
                return false;
            }
        }

        private string ValidateRange(string text, int min, int max)
        {
            try
            {
                int value = int.Parse(text);
                if (value < min || value > max)
                {
                    return string.Format(Resources.Messages.OutOfRangeValueForOptionWindow,
                                          min, max);
                }

                return null;
            }
            catch
            {
                return Resources.Messages.InvalidValueForOptionWindow;
            }
        }

        private string GetErrorMessage(string name)
        {
            string message = null;

            switch (name)
            {
                case UpdateIntervalName:
                    message = ValidateRange(this.UpdateIntervalText, 10, 300);
                    break;
            }

            return message;
        }
    }
}
