﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using Nintendo.ToolFoundation.ComponentModel;
using System.Windows;

namespace NintendoWare.Spy.Settings
{
    public class WindowPosition : ObservableObject
    {
        public static readonly WindowPosition Invalid = new WindowPosition();

        //-----------------------------------------------------------------

        private double _left = double.NaN;
        private double _top = double.NaN;
        private double _width = 0;
        private double _height = 0;
        private WindowState _windowState = WindowState.Normal;

        //-----------------------------------------------------------------

        public double Left
        {
            get { return _left; }
            set { this.SetPropertyValue(ref _left, value); }
        }

        public double Top
        {
            get { return _top; }
            set { this.SetPropertyValue(ref _top, value); }
        }

        public double Width
        {
            get { return _width; }
            set { this.SetPropertyValue(ref _width, value); }
        }

        public double Height
        {
            get { return _height; }
            set { this.SetPropertyValue(ref _height, value); }
        }

        public WindowState WindowState
        {
            get { return _windowState; }
            set { this.SetPropertyValue(ref _windowState, value); }
        }
    }
}
