﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using NintendoWare.Spy.Foundation;
using NintendoWare.Spy.Settings;

namespace NintendoWare.Spy.Commands
{
    /// <summary>
    /// '録音波形の保存' コマンドの引数。
    /// </summary>
    public class AudioSaveRecordWaveDataCommandArgs : SpyPlaybackServiceCommandArgs, IDeepClonable
    {
        public SpyService SpyService { get; set; }

        public ConnectionSettings ConnectionSettings { get; set; }

        public WaveSourceOutputInfo WaveSourceOutputInfo { get; set; }

        public string OutputFilePath { get; set; }

        public AudioSaveRecordWaveDataCommandArgs()
        {
        }

        object IDeepClonable.DeepClone()
        {
            return this.DeepCloneTo(new AudioSaveRecordWaveDataCommandArgs());
        }

        protected object DeepCloneTo(AudioSaveRecordWaveDataCommandArgs toArgs)
        {
            base.DeepCloneTo(toArgs);

            toArgs.SpyService = this.SpyService;
            toArgs.WaveSourceOutputInfo = this.WaveSourceOutputInfo;
            toArgs.OutputFilePath = this.OutputFilePath;
            toArgs.ConnectionSettings = this.ConnectionSettings;

            return toArgs;
        }
    }
}
