﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Media;

namespace NintendoWare.SpySample.Windows.Controls
{
    public class FrequencyGridItem : ContentControl
    {
        private static readonly Brush DefaultStroke = Brushes.Gray;

        public static readonly DependencyProperty OrientationProperty =
            DependencyProperty.Register(
                nameof(Orientation),
                typeof(Orientation),
                typeof(FrequencyGridItem),
                new FrameworkPropertyMetadata(Orientation.Horizontal));

        public static readonly DependencyProperty StrokeProperty =
            DependencyProperty.Register(
                nameof(Stroke),
                typeof(Brush),
                typeof(FrequencyGridItem),
                new FrameworkPropertyMetadata(
                    DefaultStroke,
                    null,
                    (d, e) => Self(d).CoerceStroke(e)));

        public Orientation Orientation
        {
            get { return (Orientation)this.GetValue(OrientationProperty); }
            set { this.SetValue(OrientationProperty, value); }
        }

        public Brush Stroke
        {
            get { return (Brush)this.GetValue(StrokeProperty); }
            set { this.SetValue(StrokeProperty, value); }
        }

        static FrequencyGridItem()
        {
            DefaultStyleKeyProperty.OverrideMetadata(
                typeof(FrequencyGridItem),
                new FrameworkPropertyMetadata(typeof(FrequencyGridItem)));
        }

        private object CoerceStroke(object e)
        {
            if (e is Brush)
            {
                return e;
            }
            else
            {
                return DefaultStroke;
            }
        }

        private static FrequencyGridItem Self(object obj)
        {
            return (FrequencyGridItem)obj;
        }
    }
}
