﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using NintendoWare.Spy;
using System;
using System.Windows.Controls;
using System.Windows.Data;

namespace NintendoWare.NwSoundSpyPlugin.Windows
{
    /// <summary>
    /// TimelineGrid.xaml の相互作用ロジック
    /// </summary>
    public partial class TimelineGrid : UserControl
    {
        private SpyTimeUnit _timeUnit = SpyTimeUnit.Timestamp;

        /// <summary>
        /// 時間の表示単位
        /// </summary>
        public SpyTimeUnit TimeUnit
        {
            get { return _timeUnit; }
            set
            {
                if (_timeUnit != value)
                {
                    _timeUnit = value;
                    UpdateLabel();
                }
            }
        }

        /// <summary>
        /// グリッド線の表示フレーム
        /// </summary>
        public long Frame
        {
            get { return Convert.ToInt64(DataContext); }
        }

        private Canvas _parentCanvas = null;

        public TimelineGrid(Canvas parent, SpyTimeUnit timeUnit)
        {
            _timeUnit = timeUnit;

            InitializeComponent();

            _parentCanvas = parent;
            SetBinding(HeightProperty, new Binding("ActualHeight") { Source = _parentCanvas, });

            DataContextChanged += (sender, e) => UpdatePos();
        }

        private void UpdatePos()
        {
            Width = TimelineViewUtil.GridWidth;

            double pos = TimelineViewUtil.GetRenderPos(this.Frame);
            Canvas.SetLeft(this, Math.Floor(pos));

            UpdateLabel();
        }

        private void UpdateLabel()
        {
            gridLabel.Text = SpyTime.ConvertFrameValueToLabelString(this.Frame, this.TimeUnit);
        }
    }
}
