﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;

namespace NintendoWare.NwSoundSpyPlugin.Windows
{
    public enum DragMoveAction
    {
        Start,
        Update,
        End,
    }

    public class DragMoveEventArgs : EventArgs
    {
        public static readonly DragMoveEventArgs Start = new DragMoveEventArgs(DragMoveAction.Start);
        public static readonly DragMoveEventArgs Update = new DragMoveEventArgs(DragMoveAction.Update);
        public static readonly DragMoveEventArgs End = new DragMoveEventArgs(DragMoveAction.End);

        public DragMoveAction Action { get; private set; }

        public DragMoveEventArgs(DragMoveAction action)
        {
            this.Action = action;
        }
    }
}
