﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using Nintendo.ToolFoundation.Contracts;
using System.Collections.Generic;

namespace NintendoWare.NnAtkSpyPlugin.Windows
{
    internal class CacheDictionary<TKey, TValue>
    {
        private Dictionary<TKey, TValue> _dictionary = new Dictionary<TKey, TValue>();
        private List<TKey> _list = new List<TKey>();

        public int Capacity { get; set; }

        public CacheDictionary(int capacity)
        {
            Ensure.Argument.Range(capacity, 1, int.MaxValue);

            this.Capacity = capacity;
        }

        public bool ContainsKey(TKey key)
        {
            return _dictionary.ContainsKey(key);
        }

        public void Add(TKey key, TValue value)
        {
            _dictionary.Add(key, value);
            _list.Add(key);

            while (_list.Count > this.Capacity)
            {
                _dictionary.Remove(_list[0]);
                _list.RemoveAt(0);
            }
        }

        public bool Remove(TKey key)
        {
            if (_dictionary.Remove(key))
            {
                _list.Remove(key);

                return true;
            }

            return false;
        }

        public bool TryGetValue(TKey key, out TValue value)
        {
            if (_dictionary.TryGetValue(key, out value))
            {
                _list.Remove(key);
                _list.Add(key);

                return true;
            }

            return false;
        }

        public void Clear()
        {
            _dictionary.Clear();
            _list.Clear();
        }

        public int Count => _dictionary.Count;

        public TValue this[TKey key]
        {
            get
            {
                var value = _dictionary[key];
                _list.Remove(key);
                _list.Add(key);
                return value;
            }

            set
            {
                _dictionary[key] = value;
                _list.Remove(key);
                _list.Add(key);
            }
        }
    }
}
