﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using Nintendo.ToolFoundation.ComponentModel;
using NintendoWare.Spy;
using System;
using System.Collections.Generic;
using System.Linq;

namespace NintendoWare.NnAtkSpyPlugin.Windows
{
    internal class LoudnessMeterPanelViewModelMock : LoudnessMeterPanelViewModel
    {
        private class LoudnessProviderMock : ObservableObject, ILoudnessProvider
        {
            private List<WaveformSpyModel.LoudnessInfo> _loudnessInfos = new List<WaveformSpyModel.LoudnessInfo>();

            public SpyTime BeginTime => SpyTime.Zero;

            public int LoudnessCount => _loudnessInfos.Count;

            public bool IsLoudnessAvailable => this.SampleRate == 48000 || this.SampleRate == 32000;

            public int SampleRate => 48000; // 32000, 48000 以外の値に変更すると警告画面が表示されます。

            public int LoudnessStepSampleCount => this.SampleRate * 100 /* Loudness.StepTime */ / 1000;

            public bool IsWaveformMetadataReady => true;

            public event EventHandler LoudnessUpdateEvent;

            public LoudnessProviderMock()
            {
                BuildMockupData();
            }

            public WaveformSpyModel.LoudnessInfo GetLoudness(int loudnessIndex)
            {
                return _loudnessInfos[loudnessIndex];
            }

            public void UpdateLoudness()
            {
            }

            public void InvokeLoudnessUpdateEvent()
            {
                this.LoudnessUpdateEvent?.Invoke(this, EventArgs.Empty);
            }

            private void BuildMockupData()
            {
                foreach (var x in Enumerable.Range(0, 100))
                {
                    int loudnessIndex = _loudnessInfos.Count;
                    var loudnessInfo = new WaveformSpyModel.LoudnessInfo()
                    {
                        SampleIndex = 4800 * loudnessIndex,
                        LoudnessIndex = loudnessIndex,
                        MomentaryLoudnessValue = (float)CalculateValue(loudnessIndex, 0),
                        ShortTermLoudnessValue = (float)CalculateValue(loudnessIndex, 1),
                        AbsGatedLoudnessValue = (float)CalculateValue(loudnessIndex, 2),
                        RelGatedLoudnessValue = (float)CalculateValue(loudnessIndex, 3),
                    };

                    loudnessInfo.Channels.ForEach((c, i) =>
                    {
                        c.PeakValue = (float)CalculateValue(loudnessIndex, 4 + i * 2);
                        c.TruePeakValue = (float)CalculateValue(loudnessIndex, 6 + i * 2);
                        c.RmsValue = (float)CalculateValue(loudnessIndex, 5 + i * 2);
                    });

                    _loudnessInfos.Add(loudnessInfo);
                }
            }

            private double CalculateValue(double x, int index)
            {
                return 50 * Math.Sin(x * 2.0 + index) + -50;
            }
        }

        public LoudnessMeterPanelViewModelMock()
        {
            var model = new LoudnessProviderMock();

            this.AttachModel(model);

            this.ChartMomentary.IsVisible = false;
            this.LevelShortTerm.IsVisible = false;

            model.InvokeLoudnessUpdateEvent();
        }
    }
}
