﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.Collections.Specialized;
using System.ComponentModel;
using System.Dynamic;
using System.Globalization;
using System.IO;
using System.Linq;
using System.Reflection;
using System.Text;
using System.Threading.Tasks;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Data;
using System.Windows.Documents;
using System.Windows.Input;
using System.Windows.Markup;
using System.Windows.Media;
using System.Windows.Media.Imaging;
using System.Windows.Navigation;
using System.Windows.Shapes;
using System.Xml;
using Xceed.Wpf.AvalonDock;
using Xceed.Wpf.AvalonDock.Controls;
using Xceed.Wpf.AvalonDock.Layout.Serialization;
using Xceed.Wpf.Toolkit;

namespace WaveSoundEditor.Windows
{
    using Commands;
    using Nintendo.AudioToolkit.Menu;
    using Nintendo.AudioToolkit.Views;
    using Nintendo.AudioToolkit.Extensions;

    /// <summary>
    ///
    /// </summary>
    public class MainWindowViewModel
    {
        private ObservableCollection<IMenuItemViewModel> menuItems = new ObservableCollection<IMenuItemViewModel>();
        private ObservableCollection<PanelViewModel> panelViewModels = new ObservableCollection<PanelViewModel>();
        private ObservableCollection<DocumentPanelViewModel> documentViewModels = new ObservableCollection<DocumentPanelViewModel>();

        public ObservableCollection<IMenuItemViewModel> MenuItems
        {
            get
            {
                return this.menuItems;
            }
        }

        public ObservableCollection<PanelViewModel> PanelViewModels
        {
            get
            {
                return this.panelViewModels;
            }
        }

        public ObservableCollection<DocumentPanelViewModel> DocumentViewModels
        {
            get
            {
                return this.documentViewModels;
            }
        }
    }

    /// <summary>
    ///
    /// </summary>
    public class MainWindowPresenter : IPresenter
    {
        private MainWindowViewModel viewModel = null;
        private MainWindow view = null;

        //private SoundEditPresenter soundEditPresenter = null;

        /// <summary>
        ///
        /// </summary>
        public void Initialize()
        {
            //
            this.viewModel = new MainWindowViewModel();
            this.view = new MainWindow();
            this.view.DataContext = this.viewModel;

            //
            //this.soundEditPresenter = new SoundEditPresenter();
            //this.soundEditPresenter.Initialize();
            //this.viewModel.PanelViewModels.Add(new PanelViewModel() { Content = this.soundEditPresenter.View, PanelTitle = "SoundEditView", ContentId = "SoundEditView" });

            //
            this.viewModel.DocumentViewModels.Add(new DocumentPanelViewModel() { Content = new TextBox() { Text = "Text" }});

            //
            this.InitializeMenu();
        }

        /// <summary>
        ///
        /// </summary>
        public void Run()
        {
            this.Initialize();
            this.view.Show();
        }

        /// <summary>
        ///
        /// </summary>
        private void InitializeMenu()
        {
            var menuItemFile = new MenuItemViewModel(Properties.Resources.MenuItem_File, null);
            menuItemFile.Items.Add(new MenuItemViewModel("A0", null));
            menuItemFile.Items.Add(new MenuSeparatorViewModel());
            this.viewModel.MenuItems.Add(menuItemFile);

            var menuItemEdit = new MenuItemViewModel(Properties.Resources.MenuItem_Edit, null);
            menuItemEdit.Items.Add(new MenuItemViewModel("B0", null));
            this.viewModel.MenuItems.Add(menuItemEdit);

            var menuItemHelp = new MenuItemViewModel(Properties.Resources.MenuItem_Help, null);
            menuItemHelp.Items.Add(new MenuItemViewModel(Properties.Resources.MenuItem_Version, new VersionCommand()));
            this.viewModel.MenuItems.Add(menuItemHelp);
        }
    }

    /// <summary>
    ///
    /// </summary>
    public class PanelViewModel
    {
        public PanelViewModel()
        {
            this.IsVisible = true;
        }

        public Control Content { get; set; }
        public string PanelTitle { get; set; }
        public string ContentId { get; set; }
        public bool IsVisible { get; set; }
    }

    /// <summary>
    ///
    /// </summary>
    public class DocumentPanelViewModel
    {
        public DocumentPanelViewModel()
        {
            this.IsVisible = true;
        }

        public Control Content { get; set; }
        public string PanelTitle { get; set; }
        public string ContentId { get; set; }
        public bool IsVisible { get; set; }
    }

    /// <summary>
    ///
    /// </summary>
    [ContentProperty("Style")]
    public class StyleTemplate
    {
        public object DataType { get; set; }
        public Style Style { get; set; }
    }

    public class PanesStyleSelector : StyleSelector
    {
        public PanesStyleSelector()
        {
            TemplateList = new List<StyleTemplate>();
        }

        public List<StyleTemplate> TemplateList { get; set; }

        public override System.Windows.Style SelectStyle(object item, System.Windows.DependencyObject container)
        {
            var match = TemplateList.Where(t => t.DataType as Type == item.GetType()).FirstOrDefault();
            if (match != null) return match.Style;
            return base.SelectStyle(item, container);
        }
    }
}
