﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
namespace Nintendo.AudioToolKit.Xml
{
    using Nintendo.AudioToolkit.DataModels;
    using Nintendo.Foundation.Contracts;
    using System.Collections.Generic;
    using System.Linq;
    using System.Xml.Serialization;

    /// <summary>
    /// ウェーブサウンドトラックリソースデータの XML モデルです。
    /// </summary>
    [XmlRoot("WaveSoundTrackResource")]
    public class WaveSoundTrackResourceDataXml
    {
        private List<WaveSoundClipResourceDataXml> clipResources = new List<WaveSoundClipResourceDataXml>();

        /// <summary>
        /// 有効性を取得または設定します。
        /// </summary>
        [XmlAttribute]
        public bool IsEnabled { get; set; }

        /// <summary>
        /// クリップリソースリストを取得します。
        /// </summary>
        [XmlElement("WaveSoundClipResources")]
        public List<WaveSoundClipResourceDataXml> ClipResources
        {
            get { return this.clipResources; }
        }

        /// <summary>
        /// データモデルから XML モデルを作成します。
        /// </summary>
        /// <returns>XML モデルを返します。</returns>
        public static WaveSoundTrackResourceDataXml FromDataModel(WaveSoundTrackResourceData dataModel)
        {
            Ensure.Argument.NotNull(dataModel);

            var result = new WaveSoundTrackResourceDataXml()
            {
                IsEnabled = dataModel.IsEnabled,
            };

            dataModel.ClipResources.ForEach(
                clip => result.ClipResources.Add(WaveSoundClipResourceDataXml.FromDataModel(clip)));

            return result;
        }

        /// <summary>
        /// データモデルに変換します。
        /// </summary>
        /// <returns>変換後のデータモデルを返します。</returns>
        public WaveSoundTrackResourceData ToDataModel()
        {
            var result = new WaveSoundTrackResourceData()
            {
                IsEnabled = this.IsEnabled,
            };

            this.ClipResources.ForEach(clip => result.ClipResources.Add(clip.ToDataModel()));
            return result;
        }
    }
}
