﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.ComponentModel;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Data;
using System.Windows.Documents;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Imaging;
using System.Windows.Navigation;
using System.Windows.Shapes;
using System.Collections.Specialized;
using System.Reflection;

namespace Nintendo.AudioToolkit.DomainModels
{
    using Nintendo.Foundation.ComponentModel;
    using Nintendo.Foundation.Windows.Input;
    using Nintendo.AudioToolkit.DataModels;
    using Nintendo.AudioToolkit.Operations;
    using Nintendo.AudioToolkit.Presenters;
    using Nintendo.AudioToolkit.Windows.Controls;
    using Nintendo.AudioToolkit.Extensions;

    public class WaveSoundClipResource : ObservableObject
    {
        private readonly WaveSoundClipResourceData data = null;

        public WaveSoundClipResource(WaveSoundClipResourceData data)
        {
            this.data = data;
        }

        public WaveSoundClipResourceData Data
        {
            get { return this.data; }
        }

        public bool IsEnabled
        {
            get { return this.data.IsEnabled; }
            set
            {
                if (this.data.IsEnabled != value)
                {
                    this.OperationExecutor.SetParameter<bool>(this.data.IsEnabled, value,
                        (v) =>
                        {
                            this.data.IsEnabled = v;
                            this.NotifyPropertyChanged<bool>(() => IsEnabled);
                        });
                }
            }
        }

        public int Position
        {
            get { return this.data.Position; }
            set
            {
                if (this.data.Position != value)
                {
                    this.OperationExecutor.SetParameter<int>(this.data.Position, value,
                        (v) =>
                        {
                            this.data.Position = v;
                            this.NotifyPropertyChanged<int>(() => Position);
                        });
                }
            }
        }

        public int Row
        {
            get { return this.data.Row; }
            set
            {
                if (this.data.Row != value)
                {
                    this.OperationExecutor.SetParameter<int>(this.data.Row, value,
                        (v) =>
                        {
                            this.data.Row = v;
                            this.NotifyPropertyChanged<int>(() => Row);
                        });
                }
            }
        }

        public int StartOffset
        {
            get { return this.data.StartOffset; }
            set
            {
                if (this.data.StartOffset != value)
                {
                    this.OperationExecutor.SetParameter<int>(this.data.StartOffset, value,
                        (v) =>
                        {
                            this.data.StartOffset = v;
                            this.NotifyPropertyChanged<int>(() => StartOffset);
                        });
                }
            }
        }

        public int Duration
        {
            get { return this.data.Duration; }
            set
            {
                if (this.data.Duration != value)
                {
                    this.OperationExecutor.SetParameter<int>(this.data.Duration, value,
                        (v) =>
                        {
                            this.data.Duration = v;
                            this.NotifyPropertyChanged<int>(() => Duration);
                        });
                }
            }
        }

        public float Volume
        {
            get { return this.data.Volume; }
            set
            {
                if (this.data.Volume != value)
                {
                    this.OperationExecutor.SetParameter<float>(this.data.Volume, value,
                        (v) =>
                        {
                            this.data.Volume = v;
                            this.NotifyPropertyChanged<float>(() => Volume);
                        });
                }
            }
        }

        public float Pitch
        {
            get { return this.data.Pitch; }
            set
            {
                if (this.data.Pitch != value)
                {
                    this.OperationExecutor.SetParameter<float>(this.data.Pitch, value,
                        (v) =>
                        {
                            this.data.Pitch = v;
                            this.NotifyPropertyChanged<float>(() => Pitch);
                        });
                }
            }
        }

        public float Pan
        {
            get { return this.data.Pan; }
            set
            {
                if (this.data.Pan != value)
                {
                    this.OperationExecutor.SetParameter<float>(this.data.Pan, value,
                        (v) =>
                        {
                            this.data.Pan = v;
                            this.NotifyPropertyChanged<float>(() => Pan);
                        });
                }
            }
        }

        public string Path
        {
            get { return this.data.Path; }
            set
            {
                if (this.data.Path != value)
                {
                    this.OperationExecutor.SetParameter<string>(this.data.Path, value,
                        (v) =>
                        {
                            this.data.Path = v;
                            this.NotifyPropertyChanged<string>(() => Path);
                        });
                }
            }
        }

        public void SetStartOffsetWithPositionAndDuration(int value)
        {
            if (this.StartOffset != value)
            {
                try
                {
                    this.OperationExecutor.BeginTransaction();

                    var diff = value - this.StartOffset;
                    this.StartOffset = value;
                    this.Position += diff;
                    this.Duration -= diff;
                }
                catch
                {
                    this.OperationExecutor.CancelTransaction();
                }
                finally
                {
                    this.OperationExecutor.EndTransaction();
                }
            }
        }

        internal WaveSoundTrackResource Owner
        {
            get;
            set;
        }

        internal IOperationExecutor OperationExecutor
        {
            get;
            set;
        }
    }
}
