﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
namespace Nintendo.AudioToolkit.DataModels
{
    using System.Collections.Generic;

    /// <summary>
    /// ウェーブサウンドリソースのデータモデルです。
    /// </summary>
    public class WaveSoundResourceData
    {
        private List<WaveSoundTrackResourceData> trackResources = new List<WaveSoundTrackResourceData>();

        /// <summary>
        /// 名前を取得または設定します。
        /// </summary>
        public string Name { get; set; }

        /// <summary>
        /// トラックリソースデータリストを取得します。
        /// </summary>
        public IList<WaveSoundTrackResourceData> TrackResources
        {
            get { return this.trackResources; }
        }
    }
}
