﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "../../precompiled.h"

#include "../../Application.h"
#include <nw/snd/fnd/binary/sndfnd_PrimitiveTypes.h>
#include <mcs/ItemContainer.h>
#include <mcs/handler/EffectController.h>
#include <mcs/handler/SetEffectParametersHandler.h>

namespace {

// リクエストで送られるデータの構造。
struct PacketData
{
    nw::snd::internal::fnd::BinU32 deviceType;
    nw::snd::ToolSoundItemContainer container;
};

}

namespace nw {
namespace snd {

//----------------------------------------------------------
void
SetEffectParametersHandler::Initialize(HioChannel& activeChannel)
{
    m_ActiveChannel = &activeChannel;
}

//----------------------------------------------------------
void
SetEffectParametersHandler::OnInvoke(
    const HioMessageHeader& header,
    const void* data,
    nw::ut::IoStream& writeStream)
{
#if defined(NW_DEBUG)
    NW_LOG("SetEffectParametersHandler\n");
#endif

    NW_NULL_ASSERT(data);

    const PacketData* packetData = reinterpret_cast<const PacketData*>(data);

    Application::GetInstance().GetPanelManager().SetEffectDevice(packetData->deviceType);

    const ToolSoundItemContainer* pContainer = &packetData->container;

    // TODO : ★EffectController を使用しないようにする
    static EffectController controller;
    controller.SetEffectParameters(pContainer);

    u32 reply = HIO_RESULT_SUCCESS;
    HioMessageHeader replyHeader(header.message, sizeof(u32));
    m_ActiveChannel->GetStream().Write(&replyHeader, sizeof(HioMessageHeader));
    m_ActiveChannel->GetStream().Write(&reply, sizeof(u32));
}

} // snd
} // nw
