﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "../../precompiled.h"

#include <nw/snd/fnd/binary/sndfnd_PrimitiveTypes.h>
#include <mcs/handler/SetAnimationFrameHandler.h>
#include <anim/GfxCoordinator.h>


namespace {

struct Data
{
    nw::snd::internal::fnd::BinF32 frame;     // フレーム
    nw::snd::internal::fnd::BinS32 doEvent;   // イベント処理するかどうか
    nw::snd::internal::fnd::BinS32 doSync;    // 同期をとるかどうか
    nw::snd::internal::fnd::BinS32 direction; // 再生方向、0 = 無指定、1 = 正方向、-1 = 逆方向
};

}


namespace nw {
namespace snd {

//----------------------------------------------------------
void
SetAnimationFrameHandler::Initialize(AnimSoundController& animSoundController)
{
    m_AnimSoundController = &animSoundController;
}

//----------------------------------------------------------
void
SetAnimationFrameHandler::OnInvoke(
    const HioMessageHeader& header,
    const void* data,
    nw::ut::IoStream& writeStream)
{
    const Data* frameData = reinterpret_cast<const Data*>(data);

#if defined(NW_DEBUG)
    f32 frame = frameData->frame;
    NW_LOG("[HIO] set 3D animation frame. (%f)\n", frame);
#endif

    if (GfxCoordinator::IsInitialized())
    {
        GfxCoordinator::GetInstance().SetFrame(frameData->frame);
    }

    m_AnimSoundController->SeekDoEvent(frameData->doEvent != 0 ? true : false);
    if( frameData->direction != 0 )
    {
        m_AnimSoundController->Looped();
    }

    // TODO : ★結果コードをヘッダに含める
    HioMessageHeader replyHeader(header.message, sizeof(u32));
    //HioReplyMessageHeader replyHeader(header.message, sizeof(f32));
    //replyHeader.result = HIO_RESULT_SUCCESS;

    const u32 result = HIO_RESULT_SUCCESS;

    writeStream.Write(&replyHeader, sizeof(HioMessageHeader));
    writeStream.Write(&result, sizeof(u32));
}

} // namespace nw::snd
} // namespace nw
