﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "../../precompiled.h"

#include <nw/snd/fnd/binary/sndfnd_PrimitiveTypes.h>
#include <mcs/ItemContainer.h>
#include <mcs/handler/GetSoundInformationsHandler.h>

namespace {

enum ToolSoundPreviewSoundState {
    /* サウンドが指定されていない */
    SoundState_Disabled = 0,
    /* 停止中 */
    SoundState_Stopped = 1,
    /* 再生準備中 */
    SoundState_Preparing = 2,
    /* 再生中 */

    SoundState_Playing = 3,
    /* 一時停止中 */
    SoundState_Paused =	4,
    /* enumを4Byte型にするための定義 */
    ToolSoundPreviewSoundState_4BYTE_ENUM =	0xFFFFFFFF
};

typedef struct {
    nw::snd::internal::fnd::BinU32 state;
} ToolSoundPreviewSoundInfomation;

}

namespace nw {
namespace snd {

//----------------------------------------------------------
void
GetSoundInformationsHandler::Initialize(
    PreviewSoundArchive& previewSoundArchive,
    HioChannel& activeChannel)
{
    m_PreviewSoundArchive = &previewSoundArchive;
    m_ActiveChannel = &activeChannel;
}

//----------------------------------------------------------
void
GetSoundInformationsHandler::OnInvoke(
    const HioMessageHeader& header,
    const void* data,
    nw::ut::IoStream& writeStream)
{
#if defined(NW_DEBUG)
    //NW_LOG("GetSequenceVariablesHandler::OnInvoke\n");
#endif

    NW_NULL_ASSERT(m_PreviewSoundArchive);
    NW_NULL_ASSERT(m_ActiveChannel);

    u8 sOutputBuffer[ 2*1024 ];
    ItemContainerWriter<ToolSoundPreviewSoundInfomation> outputItems(
        reinterpret_cast<ToolSoundItemContainer*>( sOutputBuffer ),
        2*1024 );
    outputItems.WriteBegin();

    // パラメータをコンテナに格納する
    for(int i=0; i<m_PreviewSoundArchive->GetPreviewSoundCount(); ++i)
    {
        PreviewSound& previewSound = m_PreviewSoundArchive->GetPreviewSound(i);

        ToolSoundPreviewSoundInfomation* pOutputItem = outputItems.Next();
        if( NULL == pOutputItem ){
            NW_ASSERT(false);
            break;
        }

        switch (previewSound.GetState()) {
        case PreviewSound::STATE_PLAYING:
            pOutputItem->state = SoundState_Playing;
            break;

        case PreviewSound::STATE_STOPPED:
            pOutputItem->state = SoundState_Stopped;
            break;

        case PreviewSound::STATE_PAUSED:
            pOutputItem->state = SoundState_Paused;
            break;

        default:
            pOutputItem->state = SoundState_Stopped;
            break;
        }
    }

    outputItems.WriteEnd();

    HioMessageHeader replyHeader(header.message, outputItems.GetSize());
    m_ActiveChannel->GetStream().Write(&replyHeader, sizeof(HioMessageHeader));
    m_ActiveChannel->GetStream().Write(outputItems.GetBuffer(), outputItems.GetSize());
}


} // snd
} // nw
