﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "../../precompiled.h"

//#include "PreviewInclude.h"
#include <mcs/handler/EffectController.h>

namespace nw      {
namespace snd   {
    //namespace preview {

EffectController::EffectController(void)
{
    //    SoundResult sr =
        Initialize();

//     if( sr.Failed() ){
//         NW_WARNING( false, "Failed to initialize PreviewController!" );
//     }
}

EffectController::~EffectController(void)
{
    Uninitialize();
}

//Result EffectController::Initialize(unsigned int nCount/*=DEFAULT_EFFECT_COUNT*/)
void EffectController::Initialize(unsigned int nCount/*=DEFAULT_EFFECT_COUNT*/)
{
    //    if( 0 >= nCount ) return SOUND_E_FAIL;
    if( 0 >= nCount ) return;

    Uninitialize();


    Effect* pEffects = new Effect[ BUS_COUNT * nCount ];
    //NW_ASSERT_NOT_NULL( pEffects );

    unsigned int nIndex = 0;

    for( unsigned int nBus=0; nBus<BUS_COUNT; nBus++ ){

        //m_pEffects[ nBus ].assign( nCount, NULL );
        for (unsigned int i=0; i<DEFAULT_EFFECTS_COUNT; i++) {
            m_pEffects[ nBus ][ i ] = NULL;
        }

        for( unsigned int nEffect=0; nEffect<nCount; nEffect++ ){

            m_pEffects[ nBus ][ nEffect ] = &pEffects[ nIndex ];
            nIndex++;

        }

        //NW_ASSERT( m_pEffects[ nBus ].size() == nCount );

    }

    m_pEffectsBuffer = pEffects;

    //return SOUND_S_OK;
}

void EffectController::Uninitialize()
{
    if( NULL == m_pEffectsBuffer ) return;

    for( unsigned int nBus=0; nBus<BUS_COUNT; nBus++ ){

        //m_pEffects[ nBus ].clear();
        for (unsigned int i=0; i<DEFAULT_EFFECTS_COUNT; i++) {
            m_pEffects[ nBus ][ i ] = NULL;
        }
    }

    delete[] m_pEffectsBuffer;
    m_pEffectsBuffer = NULL;
}

Effect* EffectController::GetEffect(ToolSoundAuxBusType nBusType, unsigned int nEffectIndex)
{
    if( BUS_COUNT              <= nBusType )     return NULL;
    //if( m_pEffects[ 0 ].size() <= nEffectIndex ) return NULL;
    if( DEFAULT_EFFECTS_COUNT <= nEffectIndex ) return NULL;

    return m_pEffects[ (unsigned int)nBusType ][ nEffectIndex ];
}

Effect* EffectController::GetEffect(const ToolSoundEffectCommonParameter* pParam)
{
    if( NULL == pParam ) return NULL;
    return m_pEffects[ pParam->busType ][ pParam->effectIndex ];
}

//Result EffectController::SetEffectParameter(const ToolSoundEffectCommonParameter* pParam)
void EffectController::SetEffectParameter(const ToolSoundEffectCommonParameter* pParam)
{
    //    if( NULL == pParam ) return SOUND_E_FAIL;
    if( NULL == pParam ) return;

    Effect* pEffect = GetEffect( pParam );
    //    if( NULL == pEffect ) return SOUND_E_FAIL;
    if( NULL == pEffect ) return;

    //return pEffect->SetParameter( pParam );
    pEffect->SetParameter( pParam );
}

//Result EffectController::SetEffectParameters(const ToolSoundItemContainer* pContainer)
void EffectController::SetEffectParameters(const ToolSoundItemContainer* pContainer)
{
    //    if( NULL == pContainer ) return SOUND_E_FAIL;
    if( NULL == pContainer ) return;

    // パラメータ配列のポインタを取得する
    const ToolSoundEffectCommonParameter* pParams = reinterpret_cast<const ToolSoundEffectCommonParameter*>
        //        ( reinterpret_cast<const u8*>( pContainer ) + pContainer->offsetForData );
        ( reinterpret_cast<const unsigned char*>( pContainer ) + pContainer->offsetForData );

    // 全てのパラメータを設定する
    for( unsigned int i=0; i<pContainer->itemCount; i++ ){
        //Result result = SetEffectParameter( pParams + i );
        SetEffectParameter( pParams + i );
        //NW_ASSERT( SOUND_SUCCEEDED( result ) );
    }

    //    return SOUND_S_OK;
}


//} // namespace preview
} // namespace snd
} // namespace nw
