﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "../precompiled.h"

#include <nw/ut.h>
#include <io/IStreamWriter.h>
#include <io/StreamWriteTask.h>

namespace nw {
namespace snd {

StreamWriteTask::StreamWriteTask() :
m_State(STATE_NOT_READY),
m_pWriter(NULL),
m_DataSize(0)
{
}

StreamWriteTask::~StreamWriteTask()
{
}

StreamWriteTask::State StreamWriteTask::GetState() const
{
    return m_State;
}

void StreamWriteTask::Update(IStreamWriter& writer, const void* pBuffer, u32 size)
{
    NW_ASSERT(m_State != STATE_READY);
    NW_NULL_ASSERT(pBuffer);
    NW_ASSERT(size <= BUFFER_SIZE);

    m_pWriter = &writer;

    // TODO : StreamWriteTask の外でエンディアン変換するように修正する
    // エンディアン変換してタスクバッファにコピーします。
    const s16* pSourceSamples = static_cast<const s16*>(pBuffer);
    s16* pDestSamples = reinterpret_cast<s16*>(m_Buffer);
    u32 sampleCount = size / sizeof(s16);

    for(u32 i = 0; i < sampleCount; ++i)
    {
        pDestSamples[i] = nw::ut::ReverseEndian(pSourceSamples[i]);
    }

    m_DataSize = size;

    m_State = STATE_READY;
}

void StreamWriteTask::Invoke()
{
    NW_ASSERTMSG(m_State == STATE_READY, "[StreamWriteTask] invalid state. : %d\n", m_State);

    u32 result = m_pWriter->Write(m_Buffer, m_DataSize);

    if(result != m_DataSize)
    {
        m_pWriter->Close();
        m_State = STATE_ERROR;
    }
    else
    {
        m_State = STATE_DONE;
    }
}

void StreamWriteTask::Reset()
{
    m_State = STATE_NOT_READY;
    m_pWriter = NULL;
    m_DataSize = 0;
}

} // snd
} // nw
