﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "../precompiled.h"

#include <controls/ParameterListItem.h>

#include <nw/dw/system/dw_NwTypeUtility.h>

namespace nw {
namespace snd {

ParameterListItem::ParameterListItem()
{
    SetIsFocusable(true);
    SetMargin(nw::internal::dw::Thickness(0.f));
    SetPadding(nw::internal::dw::Thickness(1.f, 0.f));

    m_Container.GetContents().AddItem(&m_CheckLabel);
    m_Container.GetContents().AddItem(&m_Label);
    m_Container.GetContents().AddItem(&m_ValueText);

    m_CheckLabel.SetMargin(nw::internal::dw::Thickness(0.f));
    m_CheckLabel.SetDock(nw::internal::dw::DOCK_LEFT);
    m_CheckLabel.SetVisibility(nw::internal::dw::COLLAPSED);

    m_Label.SetMargin(nw::internal::dw::Thickness(2.f, 0.f));
    m_Label.SetDock(nw::internal::dw::DOCK_LEFT);

    m_ValueText.SetMargin(nw::internal::dw::Thickness(2.f, 0.f));
    m_ValueText.SetTextAlignment(nw::internal::dw::TEXT_RIGHT);

    m_Contents.AddItem(&m_Container);
    SetContents(m_Contents);
}

const char* ParameterListItem::GetLabelText() const
{
    return m_Label.GetText();
}

void ParameterListItem::SetLabelText(const char* value)
{
    m_Label.SetText(value);
}

void ParameterListItem::SetLabelWidth(f32 value)
{
    m_Label.SetMinimumWidth(value);
}

void ParameterListItem::SetCheckVisibility(nw::internal::dw::Visibility value)
{
    m_CheckLabel.SetVisibility(value);
}

bool ParameterListItem::IsEditable() const
{
    if(!IsCheckable())
    {
        return true;
    }

    return GetIsChecked();
}

bool ParameterListItem::OnUpdateFocusedInput(const nw::internal::dw::Inputs& inputs)
{
    if(inputs.GetPad() == NULL)
    {
        return false;
    }

    const nw::dev::Pad& pad = *inputs.GetPad();

    if(pad.IsTrig(nw::dev::Pad::MASK_RIGHT) ||
        pad.IsRepeatAccel(nw::dev::Pad::MASK_RIGHT))
    {
        bool isLargeChange = pad.IsHold(nw::dev::Pad::MASK_L);
        NextValue(isLargeChange);

        return true;
    }

    if(pad.IsTrig(nw::dev::Pad::MASK_LEFT) ||
        pad.IsRepeatAccel(nw::dev::Pad::MASK_LEFT))
    {
        bool isLargeChange = pad.IsHold(nw::dev::Pad::MASK_L);
        PreviousValue(isLargeChange);

        return true;
    }

    if(pad.IsTrig(nw::dev::Pad::MASK_X))
    {
        if(IsCheckable())
        {
            SetIsChecked(!GetIsChecked());
        }

        return true;
    }

    return false;
}

void ParameterListItem::OnPrepareMeasure()
{
    if(!IsAvailable())
    {
        m_ValueText.SetText("[N/A]");
        return;
    }

    if(IsCheckable())
    {
        if(GetIsChecked())
        {
            m_CheckLabel.SetText("[*]");
        }
        else
        {
            m_CheckLabel.SetText("[ ]");
        }
    }
    else
    {
        // 余白
        m_CheckLabel.SetText("   ");
    }

    static const u32 VALUETEXT_LENGTH = 16;
    char valueText[VALUETEXT_LENGTH];

    PrintValue(valueText, VALUETEXT_LENGTH);
    m_ValueText.SetTextColor(IsEditable() ? nw::ut::Color4f::WHITE() : nw::internal::dw::NwTypeUtility::SRGBToLinear(nw::ut::Color4f::GRAY()));
    m_ValueText.SetText(valueText);
}

#if defined(NW_DEBUG)

const char* ParameterListItem::ToString() const
{
    ut::snprintf(const_cast<char*>(m_DebugText), sizeof(m_DebugText), sizeof(m_DebugText) - 1, "ParameterListItem(%s)", m_Label.GetText());
    return m_DebugText;
}

#endif

} // snd
} // nw
