﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "../precompiled.h"

#include <controls/EffectLamp.h>

#include <nw/dw/system/dw_NwTypeUtility.h>

namespace nw {
namespace snd {

EffectLamp::EffectLamp() :
m_IsSelected(false)
{
    SetIsFocusable(true);
    SetIsBordered(true);
    SetPadding(nw::internal::dw::Thickness(2.f, 0.f));
    SetBackgroundColor(nw::internal::dw::NwTypeUtility::SRGBToLinear(nw::ut::Color4f(0.13f, 0.16f, 0.20f, 1.f)));
    SetBorderColor(nw::internal::dw::NwTypeUtility::SRGBToLinear(nw::ut::Color4f::X_DIM_GRAY()));

    m_Contents.AddItem(&m_Label);
    SetContents(m_Contents);

    m_TextColor = nw::ut::Color4f::WHITE();

    m_Label.SetMargin(nw::internal::dw::Thickness(0.f));
}

const char* EffectLamp::GetText() const
{
    return m_Label.GetText();
}

void EffectLamp::SetText(const char* pText)
{
    m_Label.SetText(pText);
}

nw::ut::Color4f EffectLamp::GetTextColor() const
{
    return m_TextColor;
}

void EffectLamp::SetTextColor(nw::ut::Color4f value)
{
    m_TextColor = value;
}

bool EffectLamp::GetIsSelected() const
{
    return m_IsSelected;
}

void EffectLamp::SetIsSelected(bool value)
{
    m_IsSelected = value;
}

nw::internal::dw::UIElementRenderArgs& EffectLamp::OnPrepareRender(const nw::internal::dw::UIElementTreeContext& context)
{
    nw::internal::dw::UIElementRenderArgs& result = Base::OnPrepareRender(context);

    if(m_IsSelected)
    {
        result.SetBackgroundColor(
            GetIsContainsFocus() ?
              nw::internal::dw::NwTypeUtility::SRGBToLinear(nw::ut::Color4f::X_CORNFLOWER_BLUE())
              : nw::internal::dw::NwTypeUtility::SRGBToLinear(nw::ut::Color4f::X_DIM_GRAY()));
    }

    m_Label.SetTextColor(m_TextColor);

    return result;
}

} // snd
} // nw
