﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "../precompiled.h"

#include <anim/GfxCoordinator.h>

// cafe版の実体
#include <anim/AnimSoundTargetCafe.h>

namespace nw {
namespace snd {

GfxCoordinator::InitializeArg GfxCoordinator::s_InitializeArg;

//----------------------------------------------------------
GfxCoordinator::GfxCoordinator()
    : m_Target(NULL)
{
    NW_ASSERT_NOT_NULL(s_InitializeArg.allocator);

    AnimSoundTargetCafe::CreateArg arg;
    arg.allocator = s_InitializeArg.allocator;
    arg.shaderBinary = s_InitializeArg.shaderBinary;
    arg.shaderBinarySize = s_InitializeArg.shaderBinarySize;
    arg.fontBinary = s_InitializeArg.fontBinary;
    arg.fontBinarySize = s_InitializeArg.fontBinarySize;
    arg.screenWidth = s_InitializeArg.screenWidth;
    arg.screenHeight = s_InitializeArg.screenHeight;

    m_Target = AnimSoundTargetCafe::Create(arg);
}

//----------------------------------------------------------
GfxCoordinator::~GfxCoordinator()
{
}

//----------------------------------------------------------
void GfxCoordinator::Initialize(const InitializeArg& arg)
{
    s_InitializeArg = arg;
}

//----------------------------------------------------------
void GfxCoordinator::Finalize()
{
    GfxCoordinator& instance = GfxCoordinator::GetInstance();
    instance.m_Target->Destroy();
    s_InitializeArg.allocator->Free(instance.m_Target);
}

//----------------------------------------------------------
GfxCoordinator& GfxCoordinator::GetInstance()
{
    static GfxCoordinator s_Instance;
    return s_Instance;
}

//----------------------------------------------------------
u32 GfxCoordinator::LoadModel(const char* filePath, bool isReload)
{
    return m_Target->OnLoadModel(filePath, isReload);
}

//----------------------------------------------------------
u32 GfxCoordinator::LoadAnimation(const char* filePath, bool isReload)
{
    return m_Target->OnLoadAnimation(filePath, isReload);
}

//----------------------------------------------------------
void GfxCoordinator::Unload()
{
    m_Target->OnUnload();
}

//----------------------------------------------------------
void GfxCoordinator::UpdateInputs(const dev::Pad* pad, const nw::dev::Mouse* mouse)
{
    m_Target->OnUpdateInputs(pad, mouse);
}

//----------------------------------------------------------
void GfxCoordinator::Calc()
{
    m_Target->OnCalc();
}

//----------------------------------------------------------
void GfxCoordinator::Draw()
{
    m_Target->OnDraw();
}

//----------------------------------------------------------
void GfxCoordinator::PlayAnim()
{
    m_Target->OnPlayAnim();
}

//----------------------------------------------------------
void GfxCoordinator::StopAnim()
{
    m_Target->OnStopAnim();
}

//----------------------------------------------------------
bool GfxCoordinator::IsPlayingAnim()
{
    return m_Target->IsPlayingAnim();
}

//----------------------------------------------------------
void GfxCoordinator::SetLoop(bool flg)
{
    m_Target->OnSetLoop(flg);
}

//----------------------------------------------------------
void GfxCoordinator::SetRange(f32 start, f32 end)
{
    m_Target->OnSetRange(start, end);
}

//----------------------------------------------------------
f32 GfxCoordinator::GetRangeStart()
{
    return m_Target->OnGetRangeStart();
}

//----------------------------------------------------------
f32 GfxCoordinator::GetRangeEnd()
{
    return m_Target->OnGetRangeEnd();
}

//----------------------------------------------------------
void GfxCoordinator::SetRate(f32 rate)
{
    m_Target->OnSetRate(rate);
}

//----------------------------------------------------------
f32 GfxCoordinator::GetRate()
{
    return m_Target->OnGetRate();
}

//----------------------------------------------------------
void GfxCoordinator::SetFrame(f32 frame)
{
    m_Target->OnSetFrame(frame);
}

//----------------------------------------------------------
f32 GfxCoordinator::GetFrame()
{
    return m_Target->OnGetFrame();
}

//----------------------------------------------------------
void GfxCoordinator::SetCameraEnabled(bool isCameraEnabled)
{
    m_Target->SetCameraEnabled(isCameraEnabled);
}

} // namespace snd
} // namespace nw

// eof
