﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

namespace nw {
namespace snd {

class IResourceProvider
{
public:
    virtual void* GetResource(const char* pPath) const = 0;
    virtual bool TryGetResource(const char* pPath, void** pResource) const = 0;

    virtual const void* GetConstResource(const char* pPath) const = 0;
    virtual bool TryGetConstResource(const char* pPath, const void** pResource) const = 0;
};

} // snd
} // nw
