﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nw/dw/control/dw_UIElement.h>
#include <nw/dw/control/dw_FixedUIElementList.h>
#include <nw/dw/control/dw_FixedListBox.h>
#include <controls/SelectableParameterListItem.h>

namespace nw {
namespace snd {

class IResourceProvider;

class SoundSystemPanel : public nw::internal::dw::UIElement
{
private:
    static const u32 MAX_ITEM_COUNT = 16;

public:
    SoundSystemPanel();
    virtual ~SoundSystemPanel();

protected:
    void AddItem(nw::internal::dw::UIElement& item);

private:
    nw::internal::dw::FixedUIElementList<1> m_Contents;
    nw::internal::dw::FixedListBox<MAX_ITEM_COUNT> m_Container;
    nw::internal::dw::UIElement* m_pListItems[MAX_ITEM_COUNT];

    SelectableParameterListItem<void, nw::snd::OutputMode> m_OutputModeMain;
    SelectableParameterListItem<void, nw::snd::OutputMode> m_OutputModeDrc;

#if defined(NW_DEBUG)
public:
    /*override*/ const char* ToString() const
    {
        return "SoundSystemPanel";
    }
#endif
};

} // snd
} // nw
