﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nw/dw/control/dw_UIElement.h>
#include <nw/dw/control/dw_FixedUIElementList.h>
#include <nw/dw/control/dw_FixedDockPanel.h>
#include <nw/dw/control/dw_FixedLabel.h>
#include <controls/Lamp.h>

namespace nw {
namespace snd {

template<class TContent>
class PanelFrame : public nw::internal::dw::UIElement
{
private:
    typedef nw::internal::dw::UIElement Base;

public:
    PanelFrame();

public:
    const char* GetLabel() const;
    void SetLabel(const char* value);

    Lamp& GetLamp() { return m_Lamp; }

    TContent& GetContent();

protected:
    //---------------------------------------------------------------------------
    //! @brief       UI要素描画の準備を行います。
    //!
    //! @details     UI要素描画の準備を行います。
    //!              特別な更新処理を行う場合は、この関数をオーバーライドしてください。
    //!
    //! @param[in]   context  UIElementTreeContext を指定します。
    //!
    //! @return      描画に使用するパラメータへの参照を返します。
    //---------------------------------------------------------------------------
    /* override */ nw::internal::dw::UIElementRenderArgs& OnPrepareRender(const nw::internal::dw::UIElementTreeContext& context);

private:
    nw::internal::dw::FixedUIElementList<1> m_Contents;

    nw::internal::dw::FixedDockPanel<2> m_Container;
    nw::internal::dw::FixedDockPanel<3> m_TitleBarContainer;

    nw::internal::dw::FixedLabel<64> m_Label;
    Lamp m_Lamp;
    TContent m_Content;

    nw::ut::Color4f m_ActiveBackgroundColor;
    nw::ut::Color4f m_ActiveFrameColor;
    nw::ut::Color4f m_InactiveFrameColor;
    nw::ut::Color4f m_ActiveTitleColor;
    nw::ut::Color4f m_InactiveTitleColor;
    nw::ut::Color4f m_ActiveTitleBarBackgroundColor0;
    nw::ut::Color4f m_ActiveTitleBarBackgroundColor1;
    nw::ut::Color4f m_InactiveTitleBarBackgroundColor;

#if defined(NW_DEBUG)

private:
    static const u32 DEBUG_TEXT_LENGTH = 64;

public:
    /* override */ const char* ToString() const;

private:
    char m_DebugText[DEBUG_TEXT_LENGTH];

#endif
};

} // snd
} // nw

#include "PanelFrame.hpp"
