﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#ifndef NW_STOP_ALL_HANDLER_H_
#define NW_STOP_ALL_HANDLER_H_

#include <mcs/HioProtocol.h>
#include <mcs/HioMessageHandler.h>
#include <models/PreviewSoundArchive.h>

namespace nw {
namespace snd {
class AnimSoundController;
}
}

namespace nw {
namespace snd {

class StopAllHandler : public HioMessageHandler
{
public:
    StopAllHandler() : m_PreviewSoundArchive(NULL), m_AnimSoundController(NULL) { }
    ~StopAllHandler() { }

public:
    void Initialize(PreviewSoundArchive& previewSoundArchive, AnimSoundController& animSoundController);

protected:
    //---------------------------------------------------------------------------
    //! @brief         処理対象のHIOメッセージを取得します。
    //!
    //! @return        処理対象のHIOメッセージを返します。
    //---------------------------------------------------------------------------
    /* override */ HioMessageType GetTargetMessage() const
    {
        return HIO_MESSAGE_STOP_ALL;
    }

    //---------------------------------------------------------------------------
    //! @brief         HIOメッセージを処理します。
    //!
    //! @param[in]     header  HIOメッセージヘッダを指定します。
    //! @param[in]     data    HIOメッセージデータを指定します。
    //! @param[in]     writeStream  返信用の出力ストリームを指定します。
    //---------------------------------------------------------------------------
    /* override */ void OnInvoke(
        const HioMessageHeader& header,
        const void* data,
        nw::ut::IoStream& writeStream);

private:
    PreviewSoundArchive* m_PreviewSoundArchive;
    AnimSoundController* m_AnimSoundController;
};

} // namespace nw::snd
} // namespace nw

#endif // NW_STOP_ALL_HANDLER_H_
