﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nw/dw/dw_Controls.h>

namespace nw {
namespace snd {

class ParameterListItem : public nw::internal::dw::UIElement
{
public:
    ParameterListItem();
    virtual ~ParameterListItem() { }

public:
    const char* GetLabelText() const;
    void SetLabelText(const char* value);
    void SetLabelWidth(f32 value);
    void SetCheckVisibility(nw::internal::dw::Visibility value);

    virtual bool GetIsChecked() const = 0;
    virtual void SetIsChecked(bool value) = 0;

    virtual void ResetValue() = 0;

protected:
    virtual void NextValue(bool isLargeChange) = 0;
    virtual void PreviousValue(bool isLargeChange) = 0;
    virtual void PrintValue(char* pText, u32 bufferLength) = 0;
    virtual bool IsAvailable() const = 0;
    virtual bool IsCheckable() const = 0;
    virtual bool IsEditable() const;

    /*override*/ bool OnUpdateFocusedInput(const nw::internal::dw::Inputs& inputs);

    //! @brief UI要素サイズ計算の準備を行います。
    /*override*/ void OnPrepareMeasure();

private:
    nw::internal::dw::FixedUIElementList<1> m_Contents;
    nw::internal::dw::FixedDockPanel<3> m_Container;

    nw::internal::dw::FixedLabel<4> m_CheckLabel;
    nw::internal::dw::FixedLabel<32> m_Label;
    nw::internal::dw::FixedLabel<32> m_ValueText;

#if defined(NW_DEBUG)

private:
    static const u32 DEBUG_TEXT_LENGTH = 64;

public:
    /*override*/ const char* ToString() const;

private:
    char m_DebugText[DEBUG_TEXT_LENGTH];

#endif
};

template<class TModel>
class ModelParameterListItem : public ParameterListItem
{
public:
    typedef bool (*GetIsCheckedHandler)(TModel* pModel);
    typedef void (*SetIsCheckedHandler)(TModel* pModel, bool value);

public:
    ModelParameterListItem();
    virtual ~ModelParameterListItem() { }

public:
    void Initialize(GetIsCheckedHandler pGetIsCheckedHandler, SetIsCheckedHandler pSetIsCheckedHandler);

    TModel* GetModel() const;
    void SetModel(TModel* value);

    /* override */ bool GetIsChecked() const;
    /* override */ void SetIsChecked(bool value);

protected:
    /* override */ bool IsAvailable() const;
    /* override */ bool IsCheckable() const;

private:
    GetIsCheckedHandler m_pGetIsCheckedHandler;
    SetIsCheckedHandler m_pSetIsCheckedHandler;

    TModel* m_pModel;
};

} // snd
} // nw

#include "ParameterListItem.hpp"
