﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <controls/FixedLabelPeakMeter.h>

#include <nw/dw/system/dw_NwTypeUtility.h>

namespace nw {
namespace snd {

template<int TTextLength>
const char* FixedLabelPeakMeter<TTextLength>::VALUE_FORMAT = "%5.1f%%";

template<int TTextLength>
FixedLabelPeakMeter<TTextLength>::FixedLabelPeakMeter() :
m_pValueFormat(VALUE_FORMAT)
{
    m_Contents.AddItem(&m_Container);
    SetContents(m_Contents);

    SetMargin(nw::internal::dw::Thickness(0.f));
    SetPadding(nw::internal::dw::Thickness(0.f));

    m_Container.SetMeasurement(nw::internal::dw::MEASUREMENT_AUTO_HEIGHT);

    m_Label.SetDock(nw::internal::dw::DOCK_LEFT);
    m_Label.SetMargin(nw::internal::dw::Thickness(2.f, 0.f, 0.f, 0.f));
    m_Label.SetVerticalAlignment(nw::internal::dw::VERTICAL_CENTER);

    m_Label2.SetDock(nw::internal::dw::DOCK_LEFT);
    m_Label2.SetMargin(nw::internal::dw::Thickness(0.f));
    m_Label2.SetVerticalAlignment(nw::internal::dw::VERTICAL_CENTER);
    m_Label2.SetText(":");

    m_ValueLabel.SetDock(nw::internal::dw::DOCK_LEFT);
    m_ValueLabel.SetMargin(nw::internal::dw::Thickness(0.f));
    m_ValueLabel.SetVerticalAlignment(nw::internal::dw::VERTICAL_CENTER);

    m_Label3.SetDock(nw::internal::dw::DOCK_LEFT);
    m_Label3.SetMargin(nw::internal::dw::Thickness(0.f));
    m_Label3.SetVerticalAlignment(nw::internal::dw::VERTICAL_CENTER);
    m_Label3.SetText("(");

    m_PeakValueLabel.SetDock(nw::internal::dw::DOCK_LEFT);
    m_PeakValueLabel.SetMargin(nw::internal::dw::Thickness(0.f));
    m_PeakValueLabel.SetVerticalAlignment(nw::internal::dw::VERTICAL_CENTER);

    m_Label4.SetDock(nw::internal::dw::DOCK_LEFT);
    m_Label4.SetMargin(nw::internal::dw::Thickness(0.f));
    m_Label4.SetVerticalAlignment(nw::internal::dw::VERTICAL_CENTER);
    m_Label4.SetText(")");;

    m_PeakMeter.SetMargin(nw::internal::dw::Thickness(2.f, 1.f));
    m_PeakMeter.SetBackgroundColor(nw::internal::dw::NwTypeUtility::SRGBToLinear(nw::ut::Color4f(0.332f, 0.360f, 0.399f, 1.f)));
    m_PeakMeter.SetMeasurement(nw::internal::dw::MEASUREMENT_MANUAL);
    m_PeakMeter.SetHeight(12.f);
    m_PeakMeter.SetVerticalAlignment(nw::internal::dw::VERTICAL_CENTER);

    m_Container.GetContents().AddItem(&m_Label);
    m_Container.GetContents().AddItem(&m_Label2);
    m_Container.GetContents().AddItem(&m_ValueLabel);
    m_Container.GetContents().AddItem(&m_Label3);
    m_Container.GetContents().AddItem(&m_PeakValueLabel);
    m_Container.GetContents().AddItem(&m_Label4);
    m_Container.GetContents().AddItem(&m_PeakMeter);
}

template<int TTextLength>
nw::internal::dw::Orientation FixedLabelPeakMeter<TTextLength>::GetOrientation() const
{
    return m_PeakMeter.GetOrientation();
}

template<int TTextLength>
void FixedLabelPeakMeter<TTextLength>::SetOrientation(nw::internal::dw::Orientation value)
{
    NW_ASSERTMSG(value == nw::internal::dw::HORIZONTAL, "Orientation 'VERTICAL' is not supported.");

    m_PeakMeter.SetOrientation(value);
}

template<int TTextLength>
const char* FixedLabelPeakMeter<TTextLength>::GetLabelText() const
{
    return m_Label.GetText();
}

template<int TTextLength>
void FixedLabelPeakMeter<TTextLength>::SetLabelText(const char* value)
{
    m_Label.SetText(value);
}

template<int TTextLength>
float FixedLabelPeakMeter<TTextLength>::GetValue() const
{
    return m_PeakMeter.GetValue();
}

template<int TTextLength>
void FixedLabelPeakMeter<TTextLength>::SetValue(float value)
{
    m_PeakMeter.SetValue(value);
}

template<int TTextLength>
float FixedLabelPeakMeter<TTextLength>::GetPeakValue() const
{
    return m_PeakMeter.GetPeakValue();
}

template<int TTextLength>
const char* FixedLabelPeakMeter<TTextLength>::GetValueFormat() const
{
    return m_pValueFormat;
}

template<int TTextLength>
void FixedLabelPeakMeter<TTextLength>::SetValueFormat(const char* value)
{
    m_pValueFormat = value;
}

template<int TTextLength>
float FixedLabelPeakMeter<TTextLength>::GetMinimumValue() const
{
    return m_PeakMeter.GetMinimumValue();
}

template<int TTextLength>
void FixedLabelPeakMeter<TTextLength>::SetMinimumValue(float value)
{
    m_PeakMeter.SetMinimumValue(value);
}

template<int TTextLength>
float FixedLabelPeakMeter<TTextLength>::GetMaximumValue() const
{
    return m_PeakMeter.GetMaximumValue();
}

template<int TTextLength>
void FixedLabelPeakMeter<TTextLength>::SetMaximumValue(float value)
{
    m_PeakMeter.SetMaximumValue(value);
}

template<int TTextLength>
float FixedLabelPeakMeter<TTextLength>::GetPeakHoldChange() const
{
    return m_PeakMeter.GetPeakHoldChange();
}

template<int TTextLength>
void FixedLabelPeakMeter<TTextLength>::SetPeakHoldChange(float value)
{
    m_PeakMeter.SetPeakHoldChange(value);
}

template<int TTextLength>
float FixedLabelPeakMeter<TTextLength>::GetPeakHoldFrames() const
{
    return m_PeakMeter.GetPeakHoldFrames();
}

template<int TTextLength>
void FixedLabelPeakMeter<TTextLength>::SetPeakHoldFrames(float value)
{
    m_PeakMeter.SetPeakHoldFrames(value);
}

template<int TTextLength>
const nw::ut::Color4f FixedLabelPeakMeter<TTextLength>::GetBarColor() const
{
    return m_PeakMeter.GetBarColor();
}

template<int TTextLength>
void FixedLabelPeakMeter<TTextLength>::SetBarColor(const nw::ut::Color4f& value)
{
    m_PeakMeter.SetBarColor(value);
}

template<int TTextLength>
void FixedLabelPeakMeter<TTextLength>::OnUpdate(const nw::internal::dw::UIElementTreeContext& context)
{
    static const u32 LABEL_LENGTH = 32;
    static char labelText[LABEL_LENGTH];

    // 値のテキストを設定します。
    nw::ut::snprintf(
        labelText,
        LABEL_LENGTH,
        LABEL_LENGTH - 1,
        m_pValueFormat,
        m_PeakMeter.GetValue());

    m_ValueLabel.SetText(labelText);

    // ピーク値のテキストを設定します。
    nw::ut::snprintf(
        labelText,
        LABEL_LENGTH,
        LABEL_LENGTH - 1,
        m_pValueFormat,
        m_PeakMeter.GetPeakValue());

    m_PeakValueLabel.SetText(labelText);

    // オーバーフロー時はテキスト色を変更します。
    m_ValueLabel.SetTextColor(
        m_PeakMeter.IsValueInRange() ? nw::ut::Color4f::WHITE() : nw::internal::dw::NwTypeUtility::SRGBToLinear(nw::ut::Color4f(0.8f, 0.3f, 0.3f, 1.f)));

    m_PeakValueLabel.SetTextColor(
        m_PeakMeter.IsPeakValueInRange() ? nw::ut::Color4f::WHITE() : nw::internal::dw::NwTypeUtility::SRGBToLinear(nw::ut::Color4f(0.8f, 0.3f, 0.3f, 1.f)));
}

#if defined(NW_DEBUG)

template<int TTextLength>
const char* FixedLabelPeakMeter<TTextLength>::ToString() const
{
    ut::snprintf(const_cast<char*>(m_DebugText), sizeof(m_DebugText), sizeof(m_DebugText) - 1, "FixedLabelPeakMeter<%d>", TTextLength);
    return m_DebugText;
}

#endif

} // snd
} // nw
