﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nw/dw/control/dw_UIElement.h>
#include <nw/dw/control/dw_FixedUIElementList.h>
#include <nw/dw/control/dw_FixedStackPanel.h>
#include <controls/EffectLamp.h>

namespace nw {
namespace snd {

class PreviewAuxBus;

class AuxBusControl : public nw::internal::dw::UIElement
{
private:
    static const u32 MAX_EFFECT_COUNT = 8;
    static const u32 DEFAULT_EFFECT_COUNT = 3;
    static const s32 INVALID_INDEX = -1;

public:
    AuxBusControl();
    virtual ~AuxBusControl();

public:
    void Initialize(PreviewAuxBus& model);
    void Finalize();

    const char* GetText() const;
    void SetText(const char* value);

    s32 GetEffectCount() const;
    void SetEffectCount(s32 value);

    s32 GetSelectedEffectIndex();
    EffectLamp* SetSelectedEffectIndex(s32 index);

    void SelectEffect(s32 index);

protected:
    /* override */ void OnUpdate(const nw::internal::dw::UIElementTreeContext& context);
    /* override */ void OnRender(const nw::internal::dw::UIElementTreeContext& context, nw::internal::dw::UIRenderer& renderer, nw::internal::dw::UIElementRenderArgs& args) const;

private:
    PreviewAuxBus* m_pModel;

    nw::internal::dw::FixedUIElementList<1> m_Contents;
    nw::internal::dw::FixedStackPanel<MAX_EFFECT_COUNT + 1> m_Container;
    EffectLamp m_Effects[MAX_EFFECT_COUNT];
    nw::internal::dw::FixedLabel<8> m_Label;

#if defined(NW_DEBUG)
public:
    /*override*/ const char* ToString() const
    {
        return "AuxBusControl";
    }
#endif
};

} // snd
} // nw
