﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace NintendoWare.SoundMaker
{
    using NintendoWare.SoundMakerPlugin;
    using NintendoWare.SoundMaker.Preview;
    using Runtime = NintendoWare.SoundRuntime;

    public class SeqFileReaderGeneric : ISeqFileReader
    {
        private Runtime.SeqFileReaderCafe reader;

        public SeqFileReaderGeneric(IntPtr seqData)
        {
            this.reader = new Runtime.SeqFileReaderCafe(seqData);
        }

        public void Dispose()
        {
            if (this.reader != null)
            {
                this.reader.Dispose();
            }
        }

        public IntPtr GetFileAddress()
        {
            return this.reader.GetFileAddress();
        }

        public bool ReadOffsetByLabel(string labelName, out uint offsetPtr)
        {
            return this.reader.ReadOffsetByLabel(labelName, out offsetPtr);
        }

        public uint GetAllocateTrackFlags(long commandOffset)
        {
            return this.reader.GetAllocateTrackFlags(commandOffset);
        }
    }
}
